/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.GComponent;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import generic.theme.GColor;
import generic.theme.GColorUIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GTreeRenderer
extends DefaultTreeCellRenderer
implements GComponent {
    private static final Color VALID_DROP_TARGET_COLOR = new GColor("color.bg.tree.drag");
    private static final int DEFAULT_MIN_ICON_WIDTH = 22;
    private static final Color BACKGROUND_UNSELECTED = new GColor("color.bg.tree");
    private static final Color BACKGROUND_SELECTED = new GColor("color.bg.tree.selected");
    private static final Color FOREGROUND_SELECTED = new GColor("color.fg.tree.selected");
    private Object dropTarget;
    private boolean paintDropTarget;
    private Font cachedDefaultFont;
    private Font cachedBoldFont;
    private int minIconWidth = 22;

    public GTreeRenderer() {
        this.setHTMLRenderingEnabled(false);
        this.setBackgroundNonSelectionColor(BACKGROUND_UNSELECTED);
        this.setBackgroundSelectionColor(BACKGROUND_SELECTED);
        this.setTextSelectionColor(FOREGROUND_SELECTED);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected1, boolean expanded, boolean leaf, int row, boolean hasFocus1) {
        super.getTreeCellRendererComponent(tree, value, selected1, expanded, leaf, row, hasFocus1);
        this.paintDropTarget = value == this.dropTarget;
        this.setBackground(selected1 ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor());
        if (!(value instanceof GTreeNode)) {
            return this;
        }
        GTreeNode node = (GTreeNode)value;
        String text = node.getDisplayText();
        this.setText(text);
        this.setToolTipText(node.getToolTip());
        Icon icon = this.getNodeIcon(node, expanded);
        if (icon == null) {
            icon = this.getIcon();
        } else {
            this.setIcon(icon);
        }
        this.updateIconTextGap(icon, this.minIconWidth);
        GTree gtree = node.getTree();
        GTreeFilter filter = gtree == null ? null : gtree.getFilter();
        boolean isBold = filter != null && filter.showFilterMatches() && filter.acceptsNode(node);
        this.setFont(this.getFont(isBold));
        return this;
    }

    protected Icon getNodeIcon(GTreeNode node, boolean expanded) {
        return node.getIcon(expanded);
    }

    @Override
    public void setBackgroundSelectionColor(Color newColor) {
        super.setBackgroundSelectionColor(this.fromUiResource(newColor));
    }

    @Override
    public void setBackgroundNonSelectionColor(Color newColor) {
        super.setBackgroundNonSelectionColor(this.fromUiResource(newColor));
    }

    protected Color fromUiResource(Color color) {
        if (color instanceof GColorUIResource) {
            GColorUIResource uiResource = (GColorUIResource)color;
            return uiResource.toGColor();
        }
        return color;
    }

    protected void updateIconTextGap(Icon icon, int minWidth) {
        int iconWidth = 0;
        if (icon != null) {
            iconWidth = icon.getIconWidth();
        }
        this.setIconTextGap(Math.max(minWidth - iconWidth, 2));
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.updateIconTextGap(icon, this.minIconWidth);
    }

    public int getMinIconWidth() {
        return this.minIconWidth;
    }

    public void setMinIconWidth(int minIconWidth) {
        this.minIconWidth = minIconWidth;
    }

    protected Font getFont(boolean bold) {
        Font font = this.getFont();
        if (font != this.cachedDefaultFont && font != this.cachedBoldFont) {
            this.cachedDefaultFont = font;
            this.cachedBoldFont = font.deriveFont(1);
        }
        return bold ? this.cachedBoldFont : this.cachedDefaultFont;
    }

    @Override
    public Color getBackgroundNonSelectionColor() {
        if (this.paintDropTarget) {
            return VALID_DROP_TARGET_COLOR;
        }
        return super.getBackgroundNonSelectionColor();
    }

    public void setRendererDropTarget(Object target) {
        this.dropTarget = target;
    }
}

