/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.decode;

import ghidra.app.util.PseudoInstruction;
import ghidra.pcode.emu.jit.decode.DecoderExecutor;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.lang.reflect.Method;
import java.util.List;

public class DecoderUseropLibrary
extends AnnotatedPcodeUseropLibrary<Object> {
    public DecoderUseropLibrary(PcodeUseropLibrary<byte[]> rtLib) {
        for (PcodeUseropLibrary.PcodeUseropDefinition<byte[]> opDef : rtLib.getUserops().values()) {
            if (this.ops.containsKey(opDef.getName())) continue;
            this.ops.put(opDef.getName(), new WrappedUseropDefinition(this, opDef));
        }
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop(canInline=true)
    public void emu_exec_decoded(@AnnotatedPcodeUseropLibrary.OpExecutor PcodeExecutor<Object> executor) {
        DecoderExecutor de = (DecoderExecutor)executor;
        PseudoInstruction instruction = de.decodeInstruction();
        de.addInstruction(instruction);
        PcodeProgram program = PcodeProgram.fromInstruction((Instruction)instruction, false);
        de.execute(program);
    }

    @AnnotatedPcodeUseropLibrary.PcodeUserop(canInline=true)
    public void emu_skip_decoded(@AnnotatedPcodeUseropLibrary.OpExecutor PcodeExecutor<Object> executor) {
        DecoderExecutor de = (DecoderExecutor)executor;
        de.decodeInstruction();
    }

    protected class WrappedUseropDefinition
    implements PcodeUseropLibrary.PcodeUseropDefinition<Object> {
        private final PcodeUseropLibrary.PcodeUseropDefinition<byte[]> rtOp;

        public WrappedUseropDefinition(DecoderUseropLibrary this$0, PcodeUseropLibrary.PcodeUseropDefinition<byte[]> rtOp) {
            this.rtOp = rtOp;
        }

        @Override
        public String getName() {
            return this.rtOp.getName();
        }

        @Override
        public int getInputCount() {
            return this.rtOp.getInputCount();
        }

        @Override
        public void execute(PcodeExecutor<Object> executor, PcodeUseropLibrary<Object> library, Varnode outVar, List<Varnode> inVars) {
            throw new AssertionError();
        }

        @Override
        public void execute(PcodeExecutor<Object> executor, PcodeUseropLibrary<Object> library, PcodeOp op) {
            if (this.rtOp.canInlinePcode()) {
                PcodeExecutor<Object> rawExec = executor;
                PcodeUseropLibrary<Object> rawLib = library;
                this.rtOp.execute(rawExec, rawLib, op);
            }
        }

        @Override
        public boolean isFunctional() {
            return this.rtOp.isFunctional();
        }

        @Override
        public boolean hasSideEffects() {
            return this.rtOp.hasSideEffects();
        }

        @Override
        public boolean modifiesContext() {
            return this.rtOp.modifiesContext();
        }

        @Override
        public boolean canInlinePcode() {
            return this.rtOp.canInlinePcode();
        }

        @Override
        public Method getJavaMethod() {
            return this.rtOp.getJavaMethod();
        }

        @Override
        public PcodeUseropLibrary<?> getDefiningLibrary() {
            return this.rtOp.getDefiningLibrary();
        }
    }
}

