/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoInstruction;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;

final class PdbUtil {
    PdbUtil() {
    }

    static final Address reladdr(Program program, int relativeOffset) {
        return PdbUtil.reladdr(program, (long)relativeOffset & 0xFFFFFFFFL);
    }

    static final Address reladdr(Program program, long relativeOffset) {
        return program.getImageBase().add(relativeOffset);
    }

    static final void appendComment(Program program, Address address, String text, CommentType commentType) {
        String comment = program.getListing().getComment(commentType, address);
        if (comment != null) {
            if (comment.contains((CharSequence)text)) {
                return;
            }
            text = comment + "\n" + (String)text;
        }
        SetCommentCmd.createComment((Program)program, (Address)address, (String)text, (CommentType)commentType);
    }

    static final boolean isFunction(Program program, String symbol, Address addr, int length) {
        int atpos = symbol.lastIndexOf(64);
        if (atpos > 0) {
            String s = symbol.substring(atpos + 1);
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            PseudoDisassembler dis = new PseudoDisassembler(program);
            Address tmp = addr;
            while (tmp.subtract(addr) < (long)length) {
                try {
                    PseudoInstruction instr = dis.disassemble(tmp);
                    tmp = tmp.add((long)instr.getLength());
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    static final void clearComponents(Composite composite) {
        if (composite instanceof Structure) {
            ((Structure)composite).deleteAll();
        } else {
            while (composite.getNumComponents() > 0) {
                composite.delete(0);
            }
        }
    }

    static final String getPass(int pass) {
        if (pass > 20) {
            pass %= 10;
        }
        switch (pass) {
            case 1: {
                return pass + "st pass";
            }
            case 2: {
                return pass + "nd pass";
            }
            case 3: {
                return pass + "rd pass";
            }
        }
        return pass + "th pass";
    }
}

