/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantToDependentsMapping;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;

public class ConstantToDependentsMappingBuilder
implements Serializable {
    private final Map<String, Set<String>> privateDependents = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> accessibleDependents = new HashMap<String, Set<String>>();

    public ConstantToDependentsMappingBuilder addAccessibleDependents(String constantOrigin, Collection<String> dependents) {
        dependents.forEach(dependent -> this.addAccessibleDependent(constantOrigin, (String)dependent));
        return this;
    }

    public ConstantToDependentsMappingBuilder addPrivateDependents(String constantOrigin, Collection<String> dependents) {
        dependents.forEach(dependent -> this.addPrivateDependent(constantOrigin, (String)dependent));
        return this;
    }

    public ConstantToDependentsMappingBuilder addPrivateDependent(String constantOrigin, String dependent) {
        Set accessibleDependents = this.accessibleDependents.computeIfAbsent(constantOrigin, k -> new HashSet());
        Set privateDependents = this.privateDependents.computeIfAbsent(constantOrigin, k -> new HashSet());
        if (!accessibleDependents.contains(dependent)) {
            privateDependents.add(dependent);
        }
        return this;
    }

    public ConstantToDependentsMappingBuilder addAccessibleDependent(String constantOrigin, String dependent) {
        Set accessibleDependents = this.accessibleDependents.computeIfAbsent(constantOrigin, k -> new HashSet());
        Set privateDependents = this.privateDependents.computeIfAbsent(constantOrigin, k -> new HashSet());
        accessibleDependents.add(dependent);
        privateDependents.remove(dependent);
        return this;
    }

    public ConstantToDependentsMapping build() {
        HashMap<String, DependentsSet> constantDependents = new HashMap<String, DependentsSet>();
        for (String constantOrigin : Iterables.concat(this.privateDependents.keySet(), this.accessibleDependents.keySet())) {
            Set<String> privateDependents = this.privateDependents.getOrDefault(constantOrigin, Collections.emptySet());
            Set<String> accessibleDependents = this.accessibleDependents.getOrDefault(constantOrigin, Collections.emptySet());
            constantDependents.put(constantOrigin, DependentsSet.dependentClasses(privateDependents, accessibleDependents));
        }
        return new ConstantToDependentsMapping(constantDependents);
    }
}

