/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.execution.WorkValidationWarningReporter;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.InternalBuildListener;
import org.gradle.internal.buildevents.BuildExceptionReporter;
import org.gradle.internal.buildevents.BuildResultLogger;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.logging.format.DurationFormatter;
import org.gradle.internal.logging.format.TersePrettyDurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.Nullable;

public class BuildLogger
implements InternalBuildListener,
TaskExecutionGraphListener {
    private final Logger logger;
    private final BuildExceptionReporter exceptionReporter;
    private final BuildResultLogger resultLogger;
    private final FailureFactory failureFactory;
    private String action;

    public BuildLogger(Logger logger, StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildRequestMetaData requestMetaData, BuildStartedTime buildStartedTime, Clock clock, WorkValidationWarningReporter workValidationWarningReporter, GradleEnterprisePluginManager gradleEnterprisePluginManager, FailureFactory failureFactory) {
        this.logger = logger;
        this.failureFactory = failureFactory;
        this.exceptionReporter = new BuildExceptionReporter(textOutputFactory, loggingConfiguration, requestMetaData.getClient(), gradleEnterprisePluginManager, failureFactory);
        this.resultLogger = new BuildResultLogger(textOutputFactory, buildStartedTime, clock, (DurationFormatter)new TersePrettyDurationFormatter(), workValidationWarningReporter);
    }

    public void beforeSettings(Settings settings) {
        StartParameter startParameter = settings.getStartParameter();
        this.logger.info("Starting Build");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Gradle user home: {}", (Object)startParameter.getGradleUserHomeDir());
            this.logger.debug("Current dir: {}", (Object)startParameter.getCurrentDir());
        }
    }

    public void settingsEvaluated(Settings settings) {
        SettingsInternal settingsInternal = (SettingsInternal)settings;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Settings evaluated using {}.", (Object)settingsInternal.getSettingsScript().getDisplayName());
        }
    }

    public void projectsLoaded(Gradle gradle) {
        if (this.logger.isInfoEnabled()) {
            ProjectInternal projectInternal = (ProjectInternal)gradle.getRootProject();
            this.logger.info("Projects loaded. Root project using {}.", (Object)projectInternal.getBuildScriptSource().getDisplayName());
            this.logger.info("Included projects: {}", (Object)projectInternal.getAllprojects());
        }
    }

    public void projectsEvaluated(Gradle gradle) {
        this.logger.info("All projects evaluated.");
    }

    public void graphPopulated(TaskExecutionGraph graph) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Tasks to be executed: {}", (Object)graph.getAllTasks());
            this.logger.info("Tasks that were excluded: {}", ((TaskExecutionGraphInternal)graph).getFilteredTasks());
        }
    }

    public void buildFinished(BuildResult result) {
        this.action = result.getAction();
    }

    public void logResult(Throwable buildFailure) {
        this.logResult(this.failureFactory.create(buildFailure));
    }

    public void logResult(@Nullable Failure buildFailure) {
        if (this.action == null) {
            return;
        }
        BuildResult buildResult = new BuildResult(this.action, null, buildFailure == null ? null : buildFailure.getOriginal());
        this.exceptionReporter.buildFinished(buildFailure);
        this.resultLogger.buildFinished(buildResult);
    }
}

