/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl.legacy;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.util.internal.VersionNumber;

public class DevelocityPluginCompatibility {
    @VisibleForTesting
    public static final String MINIMUM_SUPPORTED_PLUGIN_VERSION = "3.13.1";
    @VisibleForTesting
    public static final VersionNumber MINIMUM_SUPPORTED_PLUGIN_VERSION_NUMBER = VersionNumber.parse((String)"3.13.1");
    private static final String ISOLATED_PROJECTS_SUPPORTED_PLUGIN_VERSION = "3.15";
    private static final VersionNumber ISOLATED_PROJECTS_SUPPORTED_PLUGIN_VERSION_NUMBER = VersionNumber.parse((String)"3.15");

    public static boolean isUnsupportedPluginVersion(VersionNumber pluginBaseVersion) {
        return MINIMUM_SUPPORTED_PLUGIN_VERSION_NUMBER.compareTo(pluginBaseVersion) > 0;
    }

    public static String getUnsupportedPluginMessage(String pluginVersion) {
        return String.format("Gradle Enterprise plugin %s has been disabled as it is incompatible with this version of Gradle. Upgrade to Gradle Enterprise plugin %s or newer to restore functionality.", pluginVersion, MINIMUM_SUPPORTED_PLUGIN_VERSION);
    }

    public static boolean isUnsupportedWithIsolatedProjects(VersionNumber pluginBaseVersion) {
        return ISOLATED_PROJECTS_SUPPORTED_PLUGIN_VERSION_NUMBER.compareTo(pluginBaseVersion) > 0;
    }

    public static String getUnsupportedWithIsolatedProjectsMessage(String pluginVersion) {
        return String.format("Gradle Enterprise plugin %s has been disabled as it is incompatible with Isolated Projects. Upgrade to Gradle Enterprise plugin %s or newer to restore functionality.", pluginVersion, ISOLATED_PROJECTS_SUPPORTED_PLUGIN_VERSION);
    }
}

