/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.File;
import java.util.Map;
import org.gradle.process.internal.EffectiveJavaForkOptions;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonForkOptions {
    private final EffectiveJavaForkOptions forkOptions;
    private final KeepAliveMode keepAliveMode;
    private final ClassLoaderStructure classLoaderStructure;

    DaemonForkOptions(EffectiveJavaForkOptions forkOptions, KeepAliveMode keepAliveMode, ClassLoaderStructure classLoaderStructure) {
        this.forkOptions = forkOptions;
        this.keepAliveMode = keepAliveMode;
        this.classLoaderStructure = classLoaderStructure;
    }

    public KeepAliveMode getKeepAliveMode() {
        return this.keepAliveMode;
    }

    public EffectiveJavaForkOptions.ReadOnlyJvmOptions getJvmOptions() {
        return this.forkOptions.getJvmOptions();
    }

    public String getExecutable() {
        return this.forkOptions.getExecutable();
    }

    public File getWorkingDir() {
        return this.forkOptions.getWorkingDir();
    }

    public Map<String, Object> getEnvironment() {
        return this.forkOptions.getEnvironment();
    }

    public ClassLoaderStructure getClassLoaderStructure() {
        return this.classLoaderStructure;
    }

    public void copyTo(JavaExecHandleBuilder target) {
        this.forkOptions.copyTo(target);
    }

    public boolean isCompatibleWith(DaemonForkOptions other) {
        return this.forkOptions.isCompatibleWith(other.forkOptions) && this.keepAliveMode == other.getKeepAliveMode() && Objects.equal((Object)this.classLoaderStructure, (Object)other.getClassLoaderStructure());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executable", (Object)this.getExecutable()).add("minHeapSize", (Object)this.getJvmOptions().getMinHeapSize()).add("maxHeapSize", (Object)this.getJvmOptions().getMaxHeapSize()).add("jvmArgs", (Object)this.getJvmOptions().getJvmArgs()).add("keepAliveMode", (Object)this.getKeepAliveMode()).toString();
    }
}

