/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.utils.Converter;

public class RotateEvent
implements Event {
    private static final long serialVersionUID = -5467788080845086125L;
    private float _rotation;
    private Location _center;
    private long _time;

    public RotateEvent() {
        this._rotation = 0.0f;
        this._center = new Location();
    }

    public RotateEvent(float rotation, Location center, long time) {
        this._rotation = rotation;
        this._center = center;
        this._time = time;
    }

    public RotateEvent(byte[] data) {
        if (data.length < 12) {
            System.err.println("Error constructing Rotate Event.");
            this._rotation = 0.0f;
            this._center = new Location(0.0f, 0.0f);
        } else {
            this._rotation = Converter.byteArrayToFloat(data, 0);
            this._center = new Location(Converter.byteArrayToFloat(data, 4), Converter.byteArrayToFloat(data, 8));
        }
    }

    @Override
    public int getEventType() {
        return 1;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[16];
        Converter.intToByteArray(data, 0, this.getEventType());
        Converter.floatToByteArray(data, 4, this._rotation);
        Converter.floatToByteArray(data, 8, this._center.getX());
        Converter.floatToByteArray(data, 12, this._center.getY());
        return data;
    }

    public String toString() {
        return "Rotate Event - Rotation: " + this._rotation + ", Center: " + this._center.toString();
    }

    public float getRotation() {
        return this._rotation;
    }

    public long getTime() {
        return this._time;
    }

    public Location getCenter() {
        return this._center;
    }

    public void setCenter(Location center) {
        this._center = center;
    }

    public float getX() {
        return this._center.getX();
    }

    public float getY() {
        return this._center.getY();
    }
}

