/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class UniJoinAll<T>
extends AbstractUni<List<T>> {
    private final List<Uni<T>> unis;
    private final Mode mode;
    private final int concurrency;

    public UniJoinAll(List<Uni<T>> unis, Mode mode, int concurrency) {
        this.unis = unis;
        this.mode = mode;
        this.concurrency = concurrency;
    }

    @Override
    public void subscribe(UniSubscriber<? super List<T>> subscriber) {
        UniJoinAllSubscription joinAllSubscription = new UniJoinAllSubscription(subscriber);
        subscriber.onSubscribe(joinAllSubscription);
        joinAllSubscription.triggerSubscriptions();
    }

    public static enum Mode {
        COLLECT_FAILURES,
        FAIL_FAST;

    }

    private class UniJoinAllSubscription
    implements UniSubscription {
        private final UniSubscriber<? super List<T>> subscriber;
        private final AtomicReferenceArray<UniSubscription> subscriptions;
        private final AtomicBoolean cancelled;
        private final AtomicReferenceArray<T> items;
        private final List<Throwable> failures;
        private final AtomicInteger completionSignalsCount;
        private AtomicInteger nextSubscriptionIndex;

        public UniJoinAllSubscription(UniSubscriber<? super List<T>> subscriber) {
            this.subscriptions = new AtomicReferenceArray(UniJoinAll.this.unis.size());
            this.cancelled = new AtomicBoolean();
            this.items = new AtomicReferenceArray(UniJoinAll.this.unis.size());
            this.failures = Collections.synchronizedList(new ArrayList());
            this.completionSignalsCount = new AtomicInteger();
            this.subscriber = subscriber;
        }

        public void triggerSubscriptions() {
            int limit;
            if (UniJoinAll.this.concurrency != -1) {
                limit = Math.min(UniJoinAll.this.concurrency, UniJoinAll.this.unis.size());
                this.nextSubscriptionIndex = new AtomicInteger(UniJoinAll.this.concurrency - 1);
            } else {
                limit = UniJoinAll.this.unis.size();
            }
            for (int index = 0; index < limit && this.trySubscribe(index, UniJoinAll.this.unis.get(index)); ++index) {
            }
        }

        private boolean trySubscribe(int index, Uni<? extends T> uni) {
            boolean proceed;
            boolean bl = proceed = !this.cancelled.get();
            if (proceed) {
                uni.onSubscription().invoke(subscription -> this.onSubscribe(index, (UniSubscription)subscription)).subscribe().with(this.subscriber.context(), item -> this.onItem(index, item), this::onFailure);
            }
            return proceed;
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
            this.cancelSubscriptions();
        }

        private void cancelSubscriptions() {
            for (int i = 0; i < UniJoinAll.this.unis.size(); ++i) {
                UniSubscription sub = this.subscriptions.get(i);
                if (sub == null) continue;
                sub.cancel();
            }
        }

        private void onSubscribe(int index, UniSubscription subscription) {
            if (!this.cancelled.get()) {
                this.subscriptions.set(index, subscription);
            } else {
                subscription.cancel();
            }
        }

        private void onItem(int index, T item) {
            if (!this.cancelled.get()) {
                this.items.set(index, item);
                this.forwardSignalWhenCompleteOrSubscribeNext();
            }
        }

        private void forwardSignalWhenCompleteOrSubscribeNext() {
            int nextIndex;
            if (this.completionSignalsCount.incrementAndGet() == UniJoinAll.this.unis.size()) {
                this.cancelled.set(true);
                if (this.failures.isEmpty()) {
                    ArrayList result = new ArrayList(UniJoinAll.this.unis.size());
                    for (int i = 0; i < UniJoinAll.this.unis.size(); ++i) {
                        result.add(this.items.get(i));
                    }
                    this.subscriber.onItem(result);
                } else {
                    this.subscriber.onFailure(new CompositeException(this.failures));
                }
            } else if (UniJoinAll.this.concurrency != -1 && (nextIndex = this.nextSubscriptionIndex.incrementAndGet()) < UniJoinAll.this.unis.size()) {
                this.trySubscribe(nextIndex, UniJoinAll.this.unis.get(nextIndex));
            }
        }

        private void onFailure(Throwable failure) {
            switch (UniJoinAll.this.mode.ordinal()) {
                case 0: {
                    if (this.cancelled.get()) break;
                    this.failures.add(failure);
                    this.forwardSignalWhenCompleteOrSubscribeNext();
                    break;
                }
                case 1: {
                    if (!this.cancelled.compareAndSet(false, true)) break;
                    this.cancelSubscriptions();
                    this.subscriber.onFailure(failure);
                }
            }
        }
    }
}

