/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.PessimisticLockStyle;
import org.hibernate.dialect.lock.internal.LockingSupportParameterized;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class HANALockingSupport
extends LockingSupportParameterized {
    public static final HANALockingSupport HANA_LOCKING_SUPPORT = new HANALockingSupport(true, true);

    public static LockingSupport forDialectVersion(DatabaseVersion version) {
        boolean supportsWait = version.isSameOrAfter(2, 0, 10);
        boolean supportsSkipLocked = version.isSameOrAfter(2, 0, 30);
        return new HANALockingSupport(supportsWait, supportsSkipLocked);
    }

    public HANALockingSupport(boolean supportsSkipLocked) {
        this(false, supportsSkipLocked);
    }

    private HANALockingSupport(boolean supportsWait, boolean supportsSkipLocked) {
        super(PessimisticLockStyle.CLAUSE, RowLockStrategy.COLUMN, supportsWait, supportsWait, supportsSkipLocked, OuterJoinLockingType.IDENTIFIED);
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.IDENTIFIED;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return ConnectionLockTimeoutStrategy.NONE;
    }
}

