/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import java.util.Locale;

public enum RepresentationMode {
    POJO,
    MAP;


    public String getExternalName() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "pojo";
            case 1 -> "dynamic-map";
        };
    }

    public static RepresentationMode fromExternalName(String externalName) {
        RepresentationMode representationMode;
        if (externalName == null) {
            representationMode = POJO;
        } else {
            switch (externalName.toLowerCase(Locale.ROOT)) {
                case "pojo": {
                    representationMode = POJO;
                    break;
                }
                case "dynamic-map": 
                case "map": {
                    representationMode = MAP;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown RepresentationMode");
                }
            }
        }
        return representationMode;
    }
}

