/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.pem.der;

import io.smallrye.certs.pem.der.ASN1ObjectIdentifier;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DerEncoder {
    private final Buffer payload = Buffer.buffer();

    public void oid(ASN1ObjectIdentifier oid) {
        int code = oid != null ? 6 : 5;
        this.encode(code, oid != null ? oid.value() : null);
    }

    public void integer(int ... encodedInteger) {
        this.encode(2, DerEncoder.toBytes(encodedInteger));
    }

    public void octetString(byte[] bytes) {
        this.encode(4, bytes);
    }

    public void sequence(byte[] bytes) {
        this.encode(48, bytes);
    }

    public void addToSequence(byte[] bytes) {
        this.payload.appendBytes(bytes);
    }

    private void write(int c) {
        this.payload.appendByte((byte)c);
    }

    private void encode(int code, byte[] bytes) {
        int length;
        this.write(code);
        int n = length = bytes != null ? bytes.length : 0;
        if (length <= 127) {
            this.write(length & 0xFF);
        } else {
            ByteArrayOutputStream lengthStream = new ByteArrayOutputStream();
            while (length != 0) {
                lengthStream.write(length & 0xFF);
                length >>= 8;
            }
            byte[] lengthBytes = lengthStream.toByteArray();
            this.write(0x80 | lengthBytes.length);
            for (int i = lengthBytes.length - 1; i >= 0; --i) {
                this.write(lengthBytes[i]);
            }
        }
        if (bytes != null) {
            this.payload.appendBytes(bytes);
        }
    }

    private static byte[] toBytes(int ... elements) {
        if (elements == null) {
            return null;
        }
        byte[] result = new byte[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = (byte)elements[i];
        }
        return result;
    }

    public byte[] toSequence() throws IOException {
        DerEncoder sequenceEncoder = new DerEncoder();
        sequenceEncoder.sequence(this.toBytes());
        return sequenceEncoder.toBytes();
    }

    public byte[] toBytes() {
        return this.payload.getBytes();
    }
}

