/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.X500DirectoryAttribute;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class SubjectDirectoryAttributesExtension
extends X509CertificateExtension {
    private final List<X500DirectoryAttribute> directoryAttributes;

    public SubjectDirectoryAttributesExtension(List<X500DirectoryAttribute> directoryAttributes) {
        super(false);
        Assert.checkNotNullParam((String)"directoryAttributes", directoryAttributes);
        this.directoryAttributes = directoryAttributes;
    }

    @Override
    public String getId() {
        return "2.5.29.9";
    }

    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (X500DirectoryAttribute directoryAttribute : this.directoryAttributes) {
            directoryAttribute.encodeTo(encoder);
        }
        encoder.endSequence();
    }
}

