/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.JavaThreadPoolFactory;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.JobQueue;
import com.sun.star.lib.uno.environments.remote.ThreadId;

public class JavaThreadPool
implements IThreadPool {
    private static final boolean DEBUG = false;
    JavaThreadPoolFactory _javaThreadPoolFactory;

    JavaThreadPool(JavaThreadPoolFactory javaThreadPoolFactory) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
    }

    @Override
    public ThreadId getThreadId() {
        return JavaThreadPoolFactory.getThreadId();
    }

    @Override
    public Object attach(ThreadId threadId) {
        JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(threadId);
        if (jobQueue == null) {
            jobQueue = new JobQueue(this._javaThreadPoolFactory, threadId, false);
        }
        jobQueue.acquire();
        return jobQueue;
    }

    @Override
    public void attach() {
        this.attach(this.getThreadId());
    }

    @Override
    public void detach(Object object, ThreadId threadId) {
        ((JobQueue)object).release();
    }

    @Override
    public void detach() {
        ThreadId threadId = this.getThreadId();
        this.detach(this._javaThreadPoolFactory.getJobQueue(threadId), threadId);
    }

    @Override
    public Object enter() throws Throwable {
        ThreadId threadId = this.getThreadId();
        return this.enter(this._javaThreadPoolFactory.getJobQueue(threadId), threadId);
    }

    @Override
    public Object enter(Object object, ThreadId threadId) throws Throwable {
        return ((JobQueue)object).enter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putJob(Job job) {
        if (!job.isRequest() || job.isSynchronous()) {
            JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(job.getThreadId());
            if (jobQueue == null) {
                jobQueue = new JobQueue(this._javaThreadPoolFactory, job.getThreadId(), true);
            }
            jobQueue.putJob(job, this);
        } else {
            JavaThreadPoolFactory javaThreadPoolFactory = this._javaThreadPoolFactory;
            synchronized (javaThreadPoolFactory) {
                JobQueue jobQueue = this._javaThreadPoolFactory.getAsyncJobQueue(job.getThreadId());
                if (jobQueue == null) {
                    jobQueue = new JobQueue(this._javaThreadPoolFactory, job.getThreadId());
                }
                jobQueue.putJob(job, this);
            }
        }
    }

    @Override
    public void dispose(Throwable throwable) {
        this._javaThreadPoolFactory.dispose(this, throwable);
    }

    @Override
    public void destroy() {
    }
}

