# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Joomla::Base

  # Checks if Joomla is up and running.
  #
  # @return [TrueClass] Joomla is up and running.
  # @return [FalseClass] Joomla is not up.
  def joomla_and_online?
    # Possible paths that we might see the generator tag.
    paths = [ '/', '/administrator/' ]

    paths.each do |path|
      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, path)
      })

      if res
        elements = res.get_html_meta_elements
        elements.each_entry do |e|
          if e.attributes['content'] && /joomla!/i === e.attributes['content'].value
            return true
          end
        end
      end
    end

    false
  end
end
