/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.pagination;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="2.18.0")
public class PageParams
implements Writeable {
    public static final String PARAM_SORT = "sort";
    public static final String PARAM_NEXT_TOKEN = "next_token";
    public static final String PARAM_SIZE = "size";
    public static final String PARAM_ASC_SORT_VALUE = "asc";
    public static final String PARAM_DESC_SORT_VALUE = "desc";
    private final String requestedTokenStr;
    private final String sort;
    private final int size;

    public PageParams(StreamInput in) throws IOException {
        this.requestedTokenStr = in.readOptionalString();
        this.sort = in.readOptionalString();
        this.size = in.readInt();
    }

    public PageParams(String requestedToken, String sort, int size) {
        this.requestedTokenStr = requestedToken;
        this.sort = sort;
        this.size = size;
    }

    public String getSort() {
        return this.sort;
    }

    public String getRequestedToken() {
        return this.requestedTokenStr;
    }

    public int getSize() {
        return this.size;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.requestedTokenStr);
        out.writeOptionalString(this.sort);
        out.writeInt(this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageParams that = (PageParams)o;
        return this.size == that.size && Objects.equals(this.requestedTokenStr, that.requestedTokenStr) && Objects.equals(this.sort, that.sort);
    }

    public int hashCode() {
        return Objects.hash(this.requestedTokenStr, this.sort, this.size);
    }
}

