/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.replication.checkpoint.MergedSegmentCheckpoint;

@ExperimentalApi
public class MergedSegmentPublisher {
    private final PublishAction publishAction;
    public static final MergedSegmentPublisher EMPTY = new MergedSegmentPublisher((indexShard, checkpoint) -> {});

    @Inject
    public MergedSegmentPublisher(PublishAction publishAction) {
        this.publishAction = Objects.requireNonNull(publishAction);
    }

    public void publish(IndexShard indexShard, MergedSegmentCheckpoint checkpoint) {
        this.publishAction.publish(indexShard, checkpoint);
    }

    @ExperimentalApi
    public static interface PublishAction {
        public void publish(IndexShard var1, MergedSegmentCheckpoint var2);
    }
}

