/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.fs;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.fs.FsBlobStore;
import org.opensearch.common.settings.Setting;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.repositories.RepositoryException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;

public class FsRepository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(FsRepository.class);
    public static final String TYPE = "fs";
    public static final Setting<String> LOCATION_SETTING = new Setting("location", "", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> REPOSITORIES_LOCATION_SETTING = new Setting<String>("repositories.fs.location", LOCATION_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting("chunk_size", new ByteSizeValue(Long.MAX_VALUE), new ByteSizeValue(5L), new ByteSizeValue(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> REPOSITORIES_CHUNK_SIZE_SETTING = Setting.byteSizeSetting("repositories.fs.chunk_size", new ByteSizeValue(Long.MAX_VALUE), new ByteSizeValue(5L), new ByteSizeValue(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final Setting<Boolean> REPOSITORIES_COMPRESS_SETTING = Setting.boolSetting("repositories.fs.compress", false, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString("base_path", new Setting.Property[0]);
    protected final Environment environment;
    protected ByteSizeValue chunkSize;
    protected BlobPath basePath;

    public FsRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, namedXContentRegistry, clusterService, recoverySettings);
        this.environment = environment;
        this.validateLocation();
        this.readMetadata();
    }

    protected void readMetadata() {
        this.chunkSize = CHUNK_SIZE_SETTING.exists(this.metadata.settings()) ? CHUNK_SIZE_SETTING.get(this.metadata.settings()) : REPOSITORIES_CHUNK_SIZE_SETTING.get(this.environment.settings());
        String basePath = BASE_PATH_SETTING.get(this.metadata.settings());
        this.basePath = Strings.hasLength((String)basePath) ? new BlobPath().add(basePath) : BlobPath.cleanPath();
    }

    protected void validateLocation() {
        String location = REPOSITORIES_LOCATION_SETTING.get(this.metadata.settings());
        if (location.isEmpty()) {
            logger.warn("the repository location is missing, it should point to a shared file system location that is available on all cluster-manager and data nodes");
            throw new RepositoryException(this.metadata.name(), "missing location");
        }
        Path locationFile = this.environment.resolveRepoFile(location);
        if (locationFile == null) {
            if (this.environment.repoFiles().length > 0) {
                logger.warn("The specified location [{}] doesn't start with any repository paths specified by the path.repo setting: [{}] ", (Object)location, (Object)this.environment.repoFiles());
                throw new RepositoryException(this.metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo");
            }
            logger.warn("The specified location [{}] should start with a repository path specified by the path.repo setting, but the path.repo setting was not set on this node", (Object)location);
            throw new RepositoryException(this.metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo because this setting is empty");
        }
    }

    @Override
    protected BlobStore createBlobStore() throws Exception {
        String location = REPOSITORIES_LOCATION_SETTING.get(this.getMetadata().settings());
        Path locationFile = this.environment.resolveRepoFile(location);
        return new FsBlobStore(this.bufferSize, locationFile, this.isReadOnly());
    }

    @Override
    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    public BlobPath basePath() {
        return this.basePath;
    }

    @Override
    public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        ArrayList restrictedSettings = new ArrayList();
        restrictedSettings.addAll(super.getRestrictedSystemRepositorySettings());
        restrictedSettings.add(LOCATION_SETTING);
        return restrictedSettings;
    }
}

