/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.store.subdirectory;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.ShardLock;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;

public class SubdirectoryAwareStore
extends Store {
    private static final Logger logger = LogManager.getLogger(SubdirectoryAwareStore.class);

    public SubdirectoryAwareStore(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock, Store.OnClose onClose, ShardPath shardPath) {
        super(shardId, indexSettings, (Directory)new SubdirectoryAwareDirectory(directory, shardPath), shardLock, onClose, shardPath);
    }

    public Store.MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        long totalNumDocs = 0L;
        SegmentInfos segmentCommitInfos = Lucene.readSegmentInfos((IndexCommit)commit);
        Store.MetadataSnapshot.LoadedMetadata regularMetadata = Store.MetadataSnapshot.loadMetadata((SegmentInfos)segmentCommitInfos, (Directory)super.directory(), (Logger)logger);
        HashMap<String, StoreFileMetadata> builder = new HashMap<String, StoreFileMetadata>(regularMetadata.fileMetadata);
        HashMap commitUserDataBuilder = new HashMap(regularMetadata.userData);
        totalNumDocs += regularMetadata.numDocs;
        return new Store.MetadataSnapshot(Collections.unmodifiableMap(builder), Collections.unmodifiableMap(commitUserDataBuilder), totalNumDocs += this.loadSubdirectoryMetadataFromSegments(commit, builder));
    }

    private long loadSubdirectoryMetadataFromSegments(IndexCommit commit, Map<String, StoreFileMetadata> builder) throws IOException {
        HashSet<String> subdirectorySegmentFiles = new HashSet<String>();
        for (String fileName : commit.getFileNames()) {
            if (Path.of(fileName, new String[0]).getParent() == null || !fileName.contains("segments")) continue;
            subdirectorySegmentFiles.add(fileName);
        }
        long totalSubdirectoryNumDocs = 0L;
        for (String segmentsFilePath : subdirectorySegmentFiles) {
            totalSubdirectoryNumDocs += this.loadMetadataFromSubdirectorySegmentsFile(segmentsFilePath, builder);
        }
        return totalSubdirectoryNumDocs;
    }

    private long loadMetadataFromSubdirectorySegmentsFile(String segmentsFilePath, Map<String, StoreFileMetadata> builder) throws IOException {
        Path filePath = Path.of(segmentsFilePath, new String[0]);
        Path parent = filePath.getParent();
        if (parent == null) {
            return 0L;
        }
        String segmentsFileName = filePath.getFileName().toString();
        Path subdirectoryFullPath = this.shardPath().getDataPath().resolve(parent.toString());
        try (FSDirectory subdirectory = FSDirectory.open((Path)subdirectoryFullPath);){
            SegmentInfos segmentInfos = SegmentInfos.readCommit((Directory)subdirectory, (String)segmentsFileName);
            SubdirectoryAwareStore.loadMetadataFromSegmentInfos(segmentInfos, (Directory)subdirectory, builder, parent);
            long l = Lucene.getNumDocs((SegmentInfos)segmentInfos);
            return l;
        }
    }

    private static void loadMetadataFromSegmentInfos(SegmentInfos segmentInfos, Directory directory, Map<String, StoreFileMetadata> builder, Path pathPrefix) throws IOException {
        Store.MetadataSnapshot.LoadedMetadata loadedMetadata = Store.MetadataSnapshot.loadMetadata((SegmentInfos)segmentInfos, (Directory)directory, (Logger)logger, (boolean)false);
        for (StoreFileMetadata metadata : loadedMetadata.fileMetadata.values()) {
            String prefixedName = pathPrefix.resolve(metadata.name()).toString();
            StoreFileMetadata prefixedMetadata = new StoreFileMetadata(prefixedName, metadata.length(), metadata.checksum(), metadata.writtenBy(), metadata.hash());
            builder.put(prefixedName, prefixedMetadata);
        }
    }

    public static class SubdirectoryAwareDirectory
    extends FilterDirectory {
        private static final Set<String> EXCLUDED_SUBDIRECTORIES = Set.of("index/", "translog/", "_state/");
        private final ShardPath shardPath;

        public SubdirectoryAwareDirectory(Directory delegate, ShardPath shardPath) {
            super(delegate);
            this.shardPath = shardPath;
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            return super.openInput(this.parseFilePath(name), context);
        }

        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            String targetFilePath = this.parseFilePath(name);
            Path targetFile = Path.of(targetFilePath, new String[0]);
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            return super.createOutput(targetFilePath, context);
        }

        public void deleteFile(String name) throws IOException {
            super.deleteFile(this.parseFilePath(name));
        }

        public long fileLength(String name) throws IOException {
            return super.fileLength(this.parseFilePath(name));
        }

        public void sync(Collection<String> names) throws IOException {
            super.sync((Collection)names.stream().map(this::parseFilePath).collect(Collectors.toList()));
        }

        public void rename(String source, String dest) throws IOException {
            super.rename(this.parseFilePath(source), this.parseFilePath(dest));
        }

        public String[] listAll() throws IOException {
            String[] delegateFiles = super.listAll();
            HashSet<String> allFiles = new HashSet<String>(Arrays.asList(delegateFiles));
            this.addSubdirectoryFiles(allFiles);
            return (String[])allFiles.stream().sorted().toArray(String[]::new);
        }

        private void addSubdirectoryFiles(final Set<String> allFiles) throws IOException {
            final Path dataPath = this.shardPath.getDataPath();
            Files.walkFileTree(dataPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Path relativePath;
                    if (attrs.isRegularFile() && (relativePath = dataPath.relativize(file)).getParent() != null) {
                        String relativePathStr = relativePath.toString();
                        if (EXCLUDED_SUBDIRECTORIES.stream().noneMatch(relativePathStr::startsWith)) {
                            allFiles.add(relativePathStr);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                    if (e instanceof NoSuchFileException) {
                        logger.debug("Skipping inaccessible file during size estimation: {}", (Object)file);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }

        private String parseFilePath(String fileName) {
            if (Path.of(fileName, new String[0]).getParent() != null) {
                return this.shardPath.getDataPath().resolve(fileName).toString();
            }
            return this.shardPath.resolveIndex().resolve(fileName).toString();
        }
    }
}

