"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports._decrypt = void 0;
const decrypt_stream_1 = require("./decrypt_stream");
// @ts-ignore
const readable_stream_1 = require("readable-stream");
async function _decrypt(decryptParameters, cmm, ciphertext, { encoding, maxBodySize } = {}) {
    const stream = (0, decrypt_stream_1._decryptStream)(decryptParameters, cmm, {
        maxBodySize,
    });
    const plaintext = [];
    let messageHeader = false;
    stream
        .once('MessageHeader', (header) => {
        messageHeader = header;
    })
        .on('data', (chunk) => plaintext.push(chunk));
    // This will check both Uint8Array|Buffer
    if (ciphertext instanceof Uint8Array) {
        stream.end(ciphertext);
    }
    else if (typeof ciphertext === 'string') {
        stream.end(Buffer.from(ciphertext, encoding));
    }
    else if (ciphertext.readable) {
        ciphertext.pipe(stream);
    }
    else {
        throw new Error('Unsupported ciphertext format');
    }
    await finishedAsync(stream);
    if (!messageHeader)
        throw new Error('Unknown format');
    return {
        plaintext: Buffer.concat(plaintext),
        messageHeader,
    };
}
exports._decrypt = _decrypt;
async function finishedAsync(stream) {
    return new Promise((resolve, reject) => {
        (0, readable_stream_1.finished)(stream, (err) => (err ? reject(err) : resolve()));
    });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVjcnlwdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9kZWNyeXB0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDOzs7QUFNdEMscURBQWlEO0FBR2pELGFBQWE7QUFDYixxREFBMEM7QUFjbkMsS0FBSyxVQUFVLFFBQVEsQ0FDNUIsaUJBQW9DLEVBQ3BDLEdBQXVDLEVBQ3ZDLFVBQTJFLEVBQzNFLEVBQUUsUUFBUSxFQUFFLFdBQVcsS0FBcUIsRUFBRTtJQUU5QyxNQUFNLE1BQU0sR0FBRyxJQUFBLCtCQUFjLEVBQUMsaUJBQWlCLEVBQUUsR0FBRyxFQUFFO1FBQ3BELFdBQVc7S0FDWixDQUFDLENBQUE7SUFFRixNQUFNLFNBQVMsR0FBYSxFQUFFLENBQUE7SUFDOUIsSUFBSSxhQUFhLEdBQTBCLEtBQUssQ0FBQTtJQUNoRCxNQUFNO1NBQ0gsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDLE1BQXFCLEVBQUUsRUFBRTtRQUMvQyxhQUFhLEdBQUcsTUFBTSxDQUFBO0lBQ3hCLENBQUMsQ0FBQztTQUNELEVBQUUsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxLQUFhLEVBQUUsRUFBRSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQTtJQUV2RCx5Q0FBeUM7SUFDekMsSUFBSSxVQUFVLFlBQVksVUFBVSxFQUFFO1FBQ3BDLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLENBQUE7S0FDdkI7U0FBTSxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUN6QyxNQUFNLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLFFBQVEsQ0FBQyxDQUFDLENBQUE7S0FDOUM7U0FBTSxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUU7UUFDOUIsVUFBVSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQTtLQUN4QjtTQUFNO1FBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQywrQkFBK0IsQ0FBQyxDQUFBO0tBQ2pEO0lBRUQsTUFBTSxhQUFhLENBQUMsTUFBTSxDQUFDLENBQUE7SUFDM0IsSUFBSSxDQUFDLGFBQWE7UUFBRSxNQUFNLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLENBQUE7SUFFckQsT0FBTztRQUNMLFNBQVMsRUFBRSxNQUFNLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxhQUFhO0tBQ2QsQ0FBQTtBQUNILENBQUM7QUFwQ0QsNEJBb0NDO0FBRUQsS0FBSyxVQUFVLGFBQWEsQ0FBQyxNQUFjO0lBQ3pDLE9BQU8sSUFBSSxPQUFPLENBQU8sQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7UUFDM0MsSUFBQSwwQkFBUSxFQUFDLE1BQU0sRUFBRSxDQUFDLEdBQVUsRUFBRSxFQUFFLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFBO0lBQ25FLENBQUMsQ0FBQyxDQUFBO0FBQ0osQ0FBQyJ9