/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CustomAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, CustomAnalyzer> {
    @Nonnull
    private final List<String> charFilter;
    @Nonnull
    private final List<String> filter;
    @Nullable
    private final Integer positionIncrementGap;
    @Nullable
    private final Integer positionOffsetGap;
    @Nonnull
    private final String tokenizer;
    public static final JsonpDeserializer<CustomAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomAnalyzer::setupCustomAnalyzerDeserializer);

    private CustomAnalyzer(Builder builder) {
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.positionIncrementGap = builder.positionIncrementGap;
        this.positionOffsetGap = builder.positionOffsetGap;
        this.tokenizer = ApiTypeHelper.requireNonNull(builder.tokenizer, this, "tokenizer");
    }

    public static CustomAnalyzer of(Function<Builder, ObjectBuilder<CustomAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Custom;
    }

    @Nonnull
    public final List<String> charFilter() {
        return this.charFilter;
    }

    @Nonnull
    public final List<String> filter() {
        return this.filter;
    }

    @Nullable
    public final Integer positionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Nullable
    public final Integer positionOffsetGap() {
        return this.positionOffsetGap;
    }

    @Nonnull
    public final String tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "custom");
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (String item0 : this.charFilter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (String item0 : this.filter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.positionIncrementGap != null) {
            generator.writeKey("position_increment_gap");
            generator.write(this.positionIncrementGap.intValue());
        }
        if (this.positionOffsetGap != null) {
            generator.writeKey("position_offset_gap");
            generator.write(this.positionOffsetGap.intValue());
        }
        generator.writeKey("tokenizer");
        generator.write(this.tokenizer);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCustomAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "char_filter");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter");
        op.add(Builder::positionIncrementGap, JsonpDeserializer.integerDeserializer(), "position_increment_gap");
        op.add(Builder::positionOffsetGap, JsonpDeserializer.integerDeserializer(), "position_offset_gap");
        op.add(Builder::tokenizer, JsonpDeserializer.stringDeserializer(), "tokenizer");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.charFilter);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.positionIncrementGap);
        result = 31 * result + Objects.hashCode(this.positionOffsetGap);
        result = 31 * result + this.tokenizer.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomAnalyzer other = (CustomAnalyzer)o;
        return Objects.equals(this.charFilter, other.charFilter) && Objects.equals(this.filter, other.filter) && Objects.equals(this.positionIncrementGap, other.positionIncrementGap) && Objects.equals(this.positionOffsetGap, other.positionOffsetGap) && this.tokenizer.equals(other.tokenizer);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CustomAnalyzer> {
        @Nullable
        private List<String> charFilter;
        @Nullable
        private List<String> filter;
        @Nullable
        private Integer positionIncrementGap;
        @Nullable
        private Integer positionOffsetGap;
        private String tokenizer;

        public Builder() {
        }

        private Builder(CustomAnalyzer o) {
            this.charFilter = Builder._listCopy(o.charFilter);
            this.filter = Builder._listCopy(o.filter);
            this.positionIncrementGap = o.positionIncrementGap;
            this.positionOffsetGap = o.positionOffsetGap;
            this.tokenizer = o.tokenizer;
        }

        private Builder(Builder o) {
            this.charFilter = Builder._listCopy(o.charFilter);
            this.filter = Builder._listCopy(o.filter);
            this.positionIncrementGap = o.positionIncrementGap;
            this.positionOffsetGap = o.positionOffsetGap;
            this.tokenizer = o.tokenizer;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder charFilter(List<String> list) {
            this.charFilter = Builder._listAddAll(this.charFilter, list);
            return this;
        }

        @Nonnull
        public final Builder charFilter(String value, String ... values) {
            this.charFilter = Builder._listAdd(this.charFilter, value, values);
            return this;
        }

        @Nonnull
        public final Builder filter(List<String> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        @Nonnull
        public final Builder filter(String value, String ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        @Nonnull
        public final Builder positionIncrementGap(@Nullable Integer value) {
            this.positionIncrementGap = value;
            return this;
        }

        @Nonnull
        public final Builder positionOffsetGap(@Nullable Integer value) {
            this.positionOffsetGap = value;
            return this;
        }

        @Nonnull
        public final Builder tokenizer(String value) {
            this.tokenizer = value;
            return this;
        }

        @Override
        @Nonnull
        public CustomAnalyzer build() {
            this._checkSingleUse();
            return new CustomAnalyzer(this);
        }
    }
}

