/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FingerprintTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, FingerprintTokenFilter> {
    @Nullable
    private final Integer maxOutputSize;
    @Nullable
    private final String separator;
    public static final JsonpDeserializer<FingerprintTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintTokenFilter::setupFingerprintTokenFilterDeserializer);

    private FingerprintTokenFilter(Builder builder) {
        super(builder);
        this.maxOutputSize = builder.maxOutputSize;
        this.separator = builder.separator;
    }

    public static FingerprintTokenFilter of(Function<Builder, ObjectBuilder<FingerprintTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Fingerprint;
    }

    @Nullable
    public final Integer maxOutputSize() {
        return this.maxOutputSize;
    }

    @Nullable
    public final String separator() {
        return this.separator;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fingerprint");
        super.serializeInternal(generator, mapper);
        if (this.maxOutputSize != null) {
            generator.writeKey("max_output_size");
            generator.write(this.maxOutputSize.intValue());
        }
        if (this.separator != null) {
            generator.writeKey("separator");
            generator.write(this.separator);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFingerprintTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        FingerprintTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxOutputSize, JsonpDeserializer.integerDeserializer(), "max_output_size");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.maxOutputSize);
        result = 31 * result + Objects.hashCode(this.separator);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FingerprintTokenFilter other = (FingerprintTokenFilter)o;
        return Objects.equals(this.maxOutputSize, other.maxOutputSize) && Objects.equals(this.separator, other.separator);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, FingerprintTokenFilter> {
        @Nullable
        private Integer maxOutputSize;
        @Nullable
        private String separator;

        public Builder() {
        }

        private Builder(FingerprintTokenFilter o) {
            super(o);
            this.maxOutputSize = o.maxOutputSize;
            this.separator = o.separator;
        }

        private Builder(Builder o) {
            super(o);
            this.maxOutputSize = o.maxOutputSize;
            this.separator = o.separator;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder maxOutputSize(@Nullable Integer value) {
            this.maxOutputSize = value;
            return this;
        }

        @Nonnull
        public final Builder separator(@Nullable String value) {
            this.separator = value;
            return this;
        }

        @Override
        @Nonnull
        public FingerprintTokenFilter build() {
            this._checkSingleUse();
            return new FingerprintTokenFilter(this);
        }
    }
}

