/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.csv;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.tribuo.Output;
import org.tribuo.data.columnar.ColumnarDataSource;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.columnar.RowProcessor;
import org.tribuo.data.csv.CSVIterator;
import org.tribuo.provenance.ConfiguredDataSourceProvenance;

public class CSVDataSource<T extends Output<T>>
extends ColumnarDataSource<T> {
    private URI dataFile;
    @Config(mandatory=true, description="Path to the CSV file.")
    private Path dataPath;
    @Config(description="The CSV separator character.")
    private char separator = (char)44;
    @Config(description="The CSV quote character.")
    private char quote = (char)34;
    @Config(description="The CSV headers. Should only be used if the csv file does not already contain headers.")
    private List<String> headers = Collections.emptyList();
    private ConfiguredDataSourceProvenance provenance;

    private CSVDataSource() {
    }

    public CSVDataSource(Path dataPath, RowProcessor<T> rowProcessor, boolean outputRequired) {
        this(dataPath, rowProcessor, outputRequired, ',', '\"');
    }

    public CSVDataSource(URI dataFile, RowProcessor<T> rowProcessor, boolean outputRequired) {
        this(dataFile, rowProcessor, outputRequired, ',', '\"');
    }

    public CSVDataSource(Path dataPath, RowProcessor<T> rowProcessor, boolean outputRequired, char separator) {
        this(dataPath, rowProcessor, outputRequired, separator, '\"');
    }

    public CSVDataSource(URI dataFile, RowProcessor<T> rowProcessor, boolean outputRequired, char separator) {
        this(dataFile, rowProcessor, outputRequired, separator, '\"');
    }

    public CSVDataSource(URI dataFile, RowProcessor<T> rowProcessor, boolean outputRequired, char separator, char quote) {
        this(dataFile, Paths.get(dataFile), rowProcessor, outputRequired, separator, quote, Collections.emptyList());
    }

    public CSVDataSource(URI dataFile, RowProcessor<T> rowProcessor, boolean outputRequired, char separator, char quote, List<String> headers) {
        this(dataFile, Paths.get(dataFile), rowProcessor, outputRequired, separator, quote, headers);
    }

    public CSVDataSource(Path dataPath, RowProcessor<T> rowProcessor, boolean outputRequired, char separator, char quote) {
        this(dataPath.toUri(), dataPath, rowProcessor, outputRequired, separator, quote, Collections.emptyList());
    }

    public CSVDataSource(Path dataPath, RowProcessor<T> rowProcessor, boolean outputRequired, char separator, char quote, List<String> headers) {
        this(dataPath.toUri(), dataPath, rowProcessor, outputRequired, separator, quote, headers);
    }

    private CSVDataSource(URI dataFile, Path dataPath, RowProcessor<T> rowProcessor, boolean outputRequired, char separator, char quote, List<String> headers) {
        super(rowProcessor.getResponseProcessor().getOutputFactory(), rowProcessor, outputRequired);
        this.dataPath = dataPath;
        this.dataFile = dataFile;
        this.separator = separator;
        this.quote = quote;
        this.headers = headers;
        this.provenance = new CSVDataSourceProvenance(this);
    }

    public void postConfig() {
        this.dataFile = this.dataPath.toUri();
        this.provenance = new CSVDataSourceProvenance(this);
    }

    public String toString() {
        return "CSVDataSource(file=" + this.dataFile + ",rowProcessor=" + this.rowProcessor.getDescription() + ")";
    }

    @Override
    public ColumnarIterator rowIterator() {
        try {
            if (this.headers.isEmpty()) {
                return new CSVIterator(this.dataFile, this.separator, this.quote);
            }
            return new CSVIterator(this.dataFile, this.separator, this.quote, this.headers);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read data", e);
        }
    }

    public ConfiguredDataSourceProvenance getProvenance() {
        return this.provenance;
    }

    static InputStream removeBOM(InputStream stream) throws IOException {
        PushbackInputStream pushbackStream = new PushbackInputStream(stream, 3);
        byte[] bomBytes = new byte[3];
        int bytesRead = pushbackStream.read(bomBytes, 0, 3);
        if (bomBytes[0] != -17 || bomBytes[1] != -69 || bomBytes[2] != -65) {
            pushbackStream.unread(bomBytes);
        }
        return pushbackStream;
    }

    static Reader removeBOM(Reader reader) throws IOException {
        PushbackReader pushbackStream = new PushbackReader(reader, 1);
        int bomChar = pushbackStream.read();
        if (bomChar != 65279) {
            pushbackStream.unread(bomChar);
        }
        return pushbackStream;
    }

    public static class CSVDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements ConfiguredDataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private final DateTimeProvenance fileModifiedTime;
        private final DateTimeProvenance dataSourceCreationTime;
        private final HashProvenance sha256Hash;

        <T extends Output<T>> CSVDataSourceProvenance(CSVDataSource<T> host) {
            super(host, "DataSource");
            this.fileModifiedTime = new DateTimeProvenance("file-modified-time", OffsetDateTime.ofInstant(Instant.ofEpochMilli(((CSVDataSource)host).dataPath.toFile().lastModified()), ZoneId.systemDefault()));
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
            this.sha256Hash = new HashProvenance(DEFAULT_HASH_TYPE, "resource-hash", ProvenanceUtil.hashResource((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, (Path)((CSVDataSource)host).dataPath));
        }

        public CSVDataSourceProvenance(Map<String, Provenance> map) {
            this(CSVDataSourceProvenance.extractProvenanceInfo(map));
        }

        private CSVDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.fileModifiedTime = (DateTimeProvenance)info.instanceValues.get("file-modified-time");
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
            this.sha256Hash = (HashProvenance)info.instanceValues.get("resource-hash");
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)CSVDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)CSVDataSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, Provenance> instanceParameters = new HashMap<String, Provenance>();
            instanceParameters.put("file-modified-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"file-modified-time", DateTimeProvenance.class, (String)CSVDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("datasource-creation-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)CSVDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("resource-hash", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"resource-hash", HashProvenance.class, (String)CSVDataSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CSVDataSourceProvenance pairs = (CSVDataSourceProvenance)((Object)o);
            return this.fileModifiedTime.equals((Object)pairs.fileModifiedTime) && this.dataSourceCreationTime.equals((Object)pairs.dataSourceCreationTime) && this.sha256Hash.equals((Object)pairs.sha256Hash);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fileModifiedTime, this.dataSourceCreationTime, this.sha256Hash);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            Map map = super.getInstanceValues();
            map.put("file-modified-time", this.fileModifiedTime);
            map.put("datasource-creation-time", this.dataSourceCreationTime);
            map.put("resource-hash", this.sha256Hash);
            return map;
        }
    }
}

