/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.DomainParameters;
import org.bouncycastle.asn1.x9.ValidationParams;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;

public final class AsymmetricDHPrivateKey
extends AsymmetricDHKey
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricDHPrivateKey(Algorithm algorithm, DHDomainParameters dHDomainParameters, BigInteger bigInteger) {
        super(algorithm, dHDomainParameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDHPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricDHPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricDHPrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey()).getValue();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final DHDomainParameters getDomainParameters() {
        DHDomainParameters dHDomainParameters = super.getDomainParameters();
        KeyUtils.checkDestroyed(this);
        return dHDomainParameters;
    }

    @Override
    public final byte[] getEncoded() {
        DHDomainParameters dHDomainParameters = this.getDomainParameters();
        if (dHDomainParameters.getQ() == null) {
            if (this.getAlgorithm().getName().startsWith("ELGAMAL")) {
                return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(dHDomainParameters.getP(), dHDomainParameters.getG())), new ASN1Integer(this.getX()));
            }
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getL())), new ASN1Integer(this.getX()));
        }
        DHValidationParameters dHValidationParameters = dHDomainParameters.getValidationParameters();
        if (dHValidationParameters != null) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), new ValidationParams(new DERBitString(dHValidationParameters.getSeed()), new ASN1Integer(dHValidationParameters.getCounter())))), new ASN1Integer(this.getX()));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), null)), new ASN1Integer(this.getX()));
    }

    public BigInteger getX() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        BigInteger bigInteger = this.x;
        KeyUtils.checkDestroyed(this);
        return bigInteger;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.x.hashCode();
        n = 31 * n + this.getDomainParameters().hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDHPrivateKey)) {
            return false;
        }
        AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)object;
        asymmetricDHPrivateKey.checkApprovedOnlyModeStatus();
        if (this.isDestroyed() || asymmetricDHPrivateKey.isDestroyed()) {
            return false;
        }
        return Arrays.constantTimeAreEqual(this.getX().toByteArray(), asymmetricDHPrivateKey.getX().toByteArray()) && this.getDomainParameters().equals(asymmetricDHPrivateKey.getDomainParameters());
    }
}

