/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.action;

import java.time.Instant;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.reportsscheduler.index.ReportDefinitionsIndex;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.model.CreateReportDefinitionRequest;
import org.opensearch.reportsscheduler.model.CreateReportDefinitionResponse;
import org.opensearch.reportsscheduler.model.DeleteReportDefinitionRequest;
import org.opensearch.reportsscheduler.model.DeleteReportDefinitionResponse;
import org.opensearch.reportsscheduler.model.GetAllReportDefinitionsRequest;
import org.opensearch.reportsscheduler.model.GetAllReportDefinitionsResponse;
import org.opensearch.reportsscheduler.model.GetReportDefinitionRequest;
import org.opensearch.reportsscheduler.model.GetReportDefinitionResponse;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetails;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetailsSearchResults;
import org.opensearch.reportsscheduler.model.UpdateReportDefinitionRequest;
import org.opensearch.reportsscheduler.model.UpdateReportDefinitionResponse;
import org.opensearch.reportsscheduler.security.UserAccessManager;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/reportsscheduler/action/ReportDefinitionActions;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "create", "Lorg/opensearch/reportsscheduler/model/CreateReportDefinitionResponse;", "request", "Lorg/opensearch/reportsscheduler/model/CreateReportDefinitionRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "update", "Lorg/opensearch/reportsscheduler/model/UpdateReportDefinitionResponse;", "Lorg/opensearch/reportsscheduler/model/UpdateReportDefinitionRequest;", "info", "Lorg/opensearch/reportsscheduler/model/GetReportDefinitionResponse;", "Lorg/opensearch/reportsscheduler/model/GetReportDefinitionRequest;", "delete", "Lorg/opensearch/reportsscheduler/model/DeleteReportDefinitionResponse;", "Lorg/opensearch/reportsscheduler/model/DeleteReportDefinitionRequest;", "getAll", "Lorg/opensearch/reportsscheduler/model/GetAllReportDefinitionsResponse;", "Lorg/opensearch/reportsscheduler/model/GetAllReportDefinitionsRequest;", "opensearch-reports-scheduler"})
public final class ReportDefinitionActions {
    @NotNull
    public static final ReportDefinitionActions INSTANCE = new ReportDefinitionActions();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ReportDefinitionActions.class);

    private ReportDefinitionActions() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final CreateReportDefinitionResponse create(@NotNull CreateReportDefinitionRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-create");
        UserAccessManager.INSTANCE.validateUser(user);
        Instant currentTime = Instant.now();
        Intrinsics.checkNotNull((Object)currentTime);
        ReportDefinitionDetails reportDefinitionDetails = new ReportDefinitionDetails("ignore", currentTime, currentTime, UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getAllAccessInfo(user), request.getReportDefinition());
        String docId = ReportDefinitionsIndex.INSTANCE.createReportDefinition(reportDefinitionDetails);
        if (docId == null) {
            throw new OpenSearchStatusException("Report Definition Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new CreateReportDefinitionResponse(docId);
    }

    @NotNull
    public final UpdateReportDefinitionResponse update(@NotNull UpdateReportDefinitionRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-update " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetails currentReportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (currentReportDefinitionDetails == null) {
            ReportDefinitionActions $this$update_u24lambda_u240 = this;
            boolean bl = false;
            Metrics.REPORT_DEFINITION_UPDATE_USER_ERROR_MISSING_REPORT_DEF_DETAILS.getCounter().increment();
            throw new OpenSearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, currentReportDefinitionDetails.getTenant(), currentReportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        Instant currentTime = Instant.now();
        String string = request.getReportDefinitionId();
        Intrinsics.checkNotNull((Object)currentTime);
        ReportDefinitionDetails reportDefinitionDetails = new ReportDefinitionDetails(string, currentTime, currentReportDefinitionDetails.getCreatedTime(), UserAccessManager.INSTANCE.getUserTenant(user), currentReportDefinitionDetails.getAccess(), request.getReportDefinition());
        if (!ReportDefinitionsIndex.INSTANCE.updateReportDefinition(request.getReportDefinitionId(), reportDefinitionDetails)) {
            Metrics.REPORT_DEFINITION_UPDATE_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Report Definition Update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new UpdateReportDefinitionResponse(request.getReportDefinitionId());
    }

    @NotNull
    public final GetReportDefinitionResponse info(@NotNull GetReportDefinitionRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-info " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetails reportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (reportDefinitionDetails == null) {
            ReportDefinitionActions $this$info_u24lambda_u241 = this;
            boolean bl = false;
            Metrics.REPORT_DEFINITION_INFO_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportDefinitionDetails.getTenant(), reportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        return new GetReportDefinitionResponse(reportDefinitionDetails, true);
    }

    @NotNull
    public final DeleteReportDefinitionResponse delete(@NotNull DeleteReportDefinitionRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-delete " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetails reportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (reportDefinitionDetails == null) {
            ReportDefinitionActions $this$delete_u24lambda_u242 = this;
            boolean bl = false;
            Metrics.REPORT_DEFINITION_DELETE_USER_ERROR_MISSING_REPORT_DEF_DETAILS.getCounter().increment();
            throw new OpenSearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportDefinitionDetails.getTenant(), reportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!ReportDefinitionsIndex.INSTANCE.deleteReportDefinition(request.getReportDefinitionId())) {
            Metrics.REPORT_DEFINITION_DELETE_SYSTEM_ERROR.getCounter().increment();
            throw new OpenSearchStatusException("Report Definition " + request.getReportDefinitionId() + " delete failed", RestStatus.REQUEST_TIMEOUT, new Object[0]);
        }
        return new DeleteReportDefinitionResponse(request.getReportDefinitionId());
    }

    @NotNull
    public final GetAllReportDefinitionsResponse getAll(@NotNull GetAllReportDefinitionsRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-getAll fromIndex:" + request.getFromIndex() + " maxItems:" + request.getMaxItems());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetailsSearchResults reportDefinitionsList = ReportDefinitionsIndex.INSTANCE.getAllReportDefinitions(UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getSearchAccessInfo(user), request.getFromIndex(), request.getMaxItems());
        return new GetAllReportDefinitionsResponse(reportDefinitionsList, true);
    }
}

