/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import org.ldaptive.AbstractConfig;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.DefaultConnectionStrategy;
import org.ldaptive.ssl.SslConfig;

public class ConnectionConfig
extends AbstractConfig {
    private String ldapUrl;
    private Duration connectTimeout;
    private Duration responseTimeout;
    private SslConfig sslConfig;
    private boolean useSSL;
    private boolean useStartTLS;
    private ConnectionInitializer connectionInitializer;
    private ConnectionStrategy connectionStrategy = new DefaultConnectionStrategy();

    public ConnectionConfig() {
    }

    public ConnectionConfig(String url) {
        this.setLdapUrl(url);
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String url) {
        this.checkImmutable();
        this.checkStringInput(url, true);
        this.logger.trace("setting ldapUrl: {}", (Object)url);
        this.ldapUrl = url;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration time) {
        this.checkImmutable();
        if (time != null && time.isNegative()) {
            throw new IllegalArgumentException("Connect timeout cannot be negative");
        }
        this.logger.trace("setting connectTimeout: {}", (Object)time);
        this.connectTimeout = time;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Duration time) {
        this.checkImmutable();
        if (time != null && time.isNegative()) {
            throw new IllegalArgumentException("Connect timeout cannot be negative");
        }
        this.logger.trace("setting responseTimeout: {}", (Object)time);
        this.responseTimeout = time;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig config) {
        this.checkImmutable();
        this.logger.trace("setting sslConfig: {}", (Object)config);
        this.sslConfig = config;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting useSSL: {}", (Object)b);
        this.useSSL = b;
    }

    public boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting useStartTLS: {}", (Object)b);
        this.useStartTLS = b;
    }

    public ConnectionInitializer getConnectionInitializer() {
        return this.connectionInitializer;
    }

    public void setConnectionInitializer(ConnectionInitializer initializer) {
        this.checkImmutable();
        this.logger.trace("setting connectionInitializer: {}", (Object)initializer);
        this.connectionInitializer = initializer;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(ConnectionStrategy strategy) {
        this.checkImmutable();
        this.logger.trace("setting connectionStrategy: {}", (Object)strategy);
        this.connectionStrategy = strategy;
    }

    public static ConnectionConfig newConnectionConfig(ConnectionConfig config) {
        ConnectionConfig cc = new ConnectionConfig();
        cc.setLdapUrl(config.getLdapUrl());
        cc.setConnectTimeout(config.getConnectTimeout());
        cc.setResponseTimeout(config.getResponseTimeout());
        cc.setSslConfig(config.getSslConfig());
        cc.setUseSSL(config.getUseSSL());
        cc.setUseStartTLS(config.getUseStartTLS());
        cc.setConnectionInitializer(config.getConnectionInitializer());
        cc.setConnectionStrategy(config.getConnectionStrategy());
        return cc;
    }

    public String toString() {
        return String.format("[%s@%d::ldapUrl=%s, connectTimeout=%s, responseTimeout=%s, sslConfig=%s, useSSL=%s, useStartTLS=%s, connectionInitializer=%s, connectionStrategy=%s]", this.getClass().getName(), this.hashCode(), this.ldapUrl, this.connectTimeout, this.responseTimeout, this.sslConfig, this.useSSL, this.useStartTLS, this.connectionInitializer, this.connectionStrategy);
    }
}

