/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.guesses;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.guesses.BaseGuess;
import com.nulabinc.zxcvbn.matchers.Match;

public class DateGuess
extends BaseGuess {
    public DateGuess(Context context) {
        super(context);
    }

    @Override
    public double exec(Match match) {
        double yearSpace = this.calculateYearSpace(match.year);
        double guesses = yearSpace * 365.0;
        if (this.hasSeparator(match.separator)) {
            guesses *= 4.0;
        }
        return guesses;
    }

    private double calculateYearSpace(int year) {
        return Math.max(Math.abs(year - REFERENCE_YEAR), 20);
    }

    private boolean hasSeparator(String separator) {
        return separator != null && !separator.isEmpty();
    }
}

