/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.graph.PermanentGraph;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogProvider {
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.logProvider");

    @NotNull
    public DetailedLogData readFirstBlock(@NotNull VirtualFile var1, @NotNull Requirements var2) throws VcsException;

    @NotNull
    public LogData readAllHashes(@NotNull VirtualFile var1, @NotNull Consumer<? super TimedVcsCommit> var2) throws VcsException;

    public void readMetadata(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull Consumer<? super VcsCommitMetadata> var3) throws VcsException;

    public void readFullDetails(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull Consumer<? super VcsFullCommitDetails> var3) throws VcsException;

    @NotNull
    public VcsKey getSupportedVcs();

    @NotNull
    public VcsLogRefManager getReferenceManager();

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> var1, @NotNull VcsLogRefresher var2);

    @NotNull
    default public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(0);
        }
        if (filterCollection == null) {
            VcsLogProvider.$$$reportNull$$$0(1);
        }
        List<TimedVcsCommit> list = this.getCommitsMatchingFilter(root, filterCollection, (PermanentGraph.Options)PermanentGraph.Options.Default, maxCount);
        if (list == null) {
            VcsLogProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    default public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @NotNull PermanentGraph.Options graphOptions, int maxCount) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(3);
        }
        if (filterCollection == null) {
            VcsLogProvider.$$$reportNull$$$0(4);
        }
        if (graphOptions == null) {
            VcsLogProvider.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("Method getCommitsMatchingFilter is not implemented the class " + this.getClass().getName());
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile var1) throws VcsException;

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile var1, @NotNull Hash var2) throws VcsException;

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> var1);

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile var1);

    @Nullable
    default public VcsLogDiffHandler getDiffHandler() {
        return null;
    }

    @Nullable
    default public VcsLogFileHistoryHandler getFileHistoryHandler(Project project) {
        return VcsLogFileHistoryHandler.getByVcs(project, this.getSupportedVcs());
    }

    @Nullable
    default public Hash resolveReference(@NotNull String ref, @NotNull VirtualFile root) {
        if (ref == null) {
            VcsLogProvider.$$$reportNull$$$0(6);
        }
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    default public VirtualFile getVcsRoot(@NotNull Project project, @NotNull VirtualFile detectedRoot, @NotNull FilePath filePath) {
        if (project == null) {
            VcsLogProvider.$$$reportNull$$$0(8);
        }
        if (detectedRoot == null) {
            VcsLogProvider.$$$reportNull$$$0(9);
        }
        if (filePath == null) {
            VcsLogProvider.$$$reportNull$$$0(10);
        }
        return detectedRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/VcsLogProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/VcsLogProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsMatchingFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsMatchingFilter";
                break;
            }
            case 2: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static interface DetailedLogData {
        @NotNull
        public List<VcsCommitMetadata> getCommits();

        @NotNull
        public Set<VcsRef> getRefs();
    }

    public static interface LogData {
        @NotNull
        public Set<VcsRef> getRefs();

        @NotNull
        public Set<VcsUser> getUsers();
    }

    public static interface Requirements {
        public int getCommitCount();
    }
}

