/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.catboost;

import ai.catboost.CatBoostModel;
import com.jetbrains.mlapi.bundle.component.JvmBundleComponentLoader;
import com.jetbrains.mlapi.catboost.CatBoostClassifier;
import com.jetbrains.mlapi.catboost.CatBoostRanker;
import com.jetbrains.mlapi.catboost.CatBoostRegressor;
import com.jetbrains.mlapi.catboost.decisionFunction.CatBoostClassifierDecisionFunction;
import com.jetbrains.mlapi.catboost.decisionFunction.CatBoostRegressorDecisionFunction;
import com.jetbrains.mlapi.catboost.decisionFunction.MLApi2CatBoostConverter;
import com.jetbrains.mlapi.model.MLModel;
import com.jetbrains.mlapi.model.pipeline.VFSNode;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J*\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/mlapi/catboost/CatBoostModelComponentLoader;", "Lcom/jetbrains/mlapi/bundle/component/JvmBundleComponentLoader;", "Lcom/jetbrains/mlapi/model/MLModel;", "()V", "name", "", "getName", "()Ljava/lang/String;", "doLoad", "Ljava/util/concurrent/CompletableFuture;", "executor", "Ljava/util/concurrent/ExecutorService;", "metadata", "Lkotlinx/serialization/json/JsonObject;", "componentDirectory", "Lcom/jetbrains/mlapi/model/pipeline/VFSNode$Directory;", "mlapi-catboost"})
public final class CatBoostModelComponentLoader
extends JvmBundleComponentLoader<MLModel<?>> {
    @NotNull
    public static final CatBoostModelComponentLoader INSTANCE = new CatBoostModelComponentLoader();
    @NotNull
    private static final String name = "catboost";

    private CatBoostModelComponentLoader() {
    }

    @NotNull
    public String getName() {
        return name;
    }

    @NotNull
    protected CompletableFuture<MLModel<?>> doLoad(@NotNull ExecutorService executor, @NotNull JsonObject metadata, @NotNull VFSNode.Directory componentDirectory) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)componentDirectory, (String)"componentDirectory");
        String modelType = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)metadata), (Object)"model_type"))).getContent();
        CompletableFuture<MLModel<?>> completableFuture = CompletableFuture.supplyAsync(() -> CatBoostModelComponentLoader.doLoad$lambda$0(componentDirectory, modelType), executor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final MLModel doLoad$lambda$0(VFSNode.Directory $componentDirectory, String $modelType) {
        Intrinsics.checkNotNullParameter((Object)$componentDirectory, (String)"$componentDirectory");
        Intrinsics.checkNotNullParameter((Object)$modelType, (String)"$modelType");
        CatBoostModel model = CatBoostModel.loadModel($componentDirectory.getFile("model.cbm").getContent());
        Intrinsics.checkNotNull((Object)model);
        MLApi2CatBoostConverter converter = new MLApi2CatBoostConverter(model);
        return (MLModel)(switch ($modelType) {
            case "regressor" -> new CatBoostRegressor(converter, new CatBoostRegressorDecisionFunction(model));
            case "classifier" -> new CatBoostClassifier(converter, new CatBoostClassifierDecisionFunction(model));
            case "ranker" -> new CatBoostRanker(converter, new CatBoostRegressorDecisionFunction(model));
            default -> throw new IllegalStateException(("This catboost model type is not supported: " + $modelType).toString());
        });
    }
}

