/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import org.languagetool.tools.TracedFunction;
import org.languagetool.tools.WrappedValue;
import org.languagetool.tools.WrappedVoid;

public enum TelemetryProvider {
    INSTANCE;

    private final OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
    private final Tracer tracer = this.openTelemetry.getTracer("LanguageTool-Server");

    public <T> T createSpan(String spanName, Attributes attributes, TracedFunction<T> tracedFunction) throws Exception {
        Span span = this.createSpan(spanName, attributes);
        span.setStatus(StatusCode.OK);
        try {
            T t;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    t = tracedFunction.call(span);
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.recordException((Throwable)ex);
                        span.setStatus(StatusCode.ERROR);
                        throw ex;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public <T> T createSpan(String spanName, Attributes attributes, WrappedValue<T> wrappedValue) throws Exception {
        Span span = this.createSpan(spanName, attributes);
        span.setStatus(StatusCode.OK);
        try {
            T t;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    t = wrappedValue.call();
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.recordException((Throwable)ex);
                        span.setStatus(StatusCode.ERROR);
                        throw ex;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public void createSpan(String spanName, Attributes attributes, WrappedVoid wrappedVoid) throws Exception {
        Span span = this.createSpan(spanName, attributes);
        span.setStatus(StatusCode.OK);
        try (Scope scope = span.makeCurrent();){
            wrappedVoid.call();
        }
        catch (Exception ex) {
            span.recordException((Throwable)ex);
            span.setStatus(StatusCode.ERROR);
            throw ex;
        }
        finally {
            span.end();
        }
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public Span createSpan(String spanName, Attributes attributes) {
        return this.tracer.spanBuilder(spanName).setAllAttributes(attributes).startSpan();
    }
}

