/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.PatchDateParser;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DefaultPatchBaseVersionProvider {
    private static final Logger LOG = Logger.getInstance(DefaultPatchBaseVersionProvider.class);
    private static final String ourRevisionPatternTemplate = "\\(revision (%s)\\)";

    public static void getBaseVersionContent(@NotNull Project project, @NotNull String versionId, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename, @NotNull @NotNull Processor<? super @NotNull String> processor2) throws VcsException {
        if (project == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(0);
        }
        if (versionId == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(2);
        }
        if (pathBeforeRename == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(4);
        }
        DefaultPatchBaseVersionProvider.runWithModalProgressIfNeeded(project, VcsBundle.message((String)"progress.text.loading.patch.base.revision", (Object[])new Object[0]), () -> {
            String content;
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
            if (vcs == null) {
                return;
            }
            VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
            if (historyProvider == null) {
                return;
            }
            String contentByRevisionId = DefaultPatchBaseVersionProvider.loadContentByRevisionId(versionId, file, pathBeforeRename, vcs);
            String string = content = contentByRevisionId != null ? contentByRevisionId : DefaultPatchBaseVersionProvider.findContentInFileHistory(versionId, file, pathBeforeRename, vcs);
            if (content != null) {
                processor2.process((Object)content);
            }
        });
    }

    @Nullable
    private static String loadContentByRevisionId(@NotNull String versionId, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename, @NotNull AbstractVcs vcs) throws VcsException {
        if (versionId == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(6);
        }
        if (pathBeforeRename == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(7);
        }
        if (vcs == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(8);
        }
        String vcsRevisionString = DefaultPatchBaseVersionProvider.parseVersionAsRevision(versionId, vcs);
        VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
        if (historyProvider instanceof VcsBaseRevisionAdviser) {
            VcsBaseRevisionAdviser revisionAdviser = (VcsBaseRevisionAdviser)historyProvider;
            return revisionAdviser.getBaseVersionContent(pathBeforeRename, vcsRevisionString != null ? vcsRevisionString : versionId);
        }
        if (vcsRevisionString == null) {
            return null;
        }
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (diffProvider == null) {
            return null;
        }
        VcsRevisionNumber revision = vcs.parseRevisionNumber(vcsRevisionString, pathBeforeRename);
        if (revision == null) {
            return null;
        }
        ContentRevision contentRevision = diffProvider.createFileContent(revision, file);
        if (contentRevision == null) {
            return null;
        }
        return contentRevision.getContent();
    }

    @Nullable
    private static String findContentInFileHistory(@NotNull String versionId, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename, @NotNull AbstractVcs vcs) throws VcsException {
        Condition condition;
        VcsRevisionNumber revision;
        if (versionId == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(9);
        }
        if (file == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(10);
        }
        if (pathBeforeRename == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(11);
        }
        if (vcs == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(12);
        }
        Date versionDate = PatchDateParser.parseVersionAsDate(versionId);
        String vcsRevisionString = DefaultPatchBaseVersionProvider.parseVersionAsRevision(versionId, vcs);
        VcsRevisionNumber vcsRevisionNumber = revision = vcsRevisionString != null ? vcs.parseRevisionNumber(vcsRevisionString, pathBeforeRename) : null;
        if (revision != null) {
            condition = fileRevision -> fileRevision.getRevisionNumber().compareTo((Object)revision) <= 0;
        } else if (versionDate != null) {
            condition = fileRevision -> {
                Date date;
                if (fileRevision instanceof VcsFileRevisionEx) {
                    VcsFileRevisionEx fileRevisionEx = (VcsFileRevisionEx)fileRevision;
                    date = fileRevisionEx.getAuthorDate();
                } else {
                    date = fileRevision.getRevisionDate();
                }
                Date date2 = date;
                return date2 != null && date2.compareTo(versionDate) <= 0;
            };
        } else {
            return null;
        }
        ProgressManager.progress2((String)VcsBundle.message((String)"loading.text2.file.history.progress", (Object[])new Object[0]));
        List<VcsFileRevision> list = DefaultPatchBaseVersionProvider.getRevisions(pathBeforeRename, vcs);
        VcsFileRevision foundRevision = (VcsFileRevision)ContainerUtil.find(list, (Condition)condition);
        if (foundRevision == null) {
            return null;
        }
        try {
            byte[] byteContent = foundRevision.loadContent();
            if (byteContent == null) {
                return null;
            }
            return LoadTextUtil.getTextByBinaryPresentation((byte[])byteContent, (VirtualFile)file, (boolean)false, (boolean)false).toString();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<VcsFileRevision> getRevisions(@NotNull FilePath pathBeforeRename, @NotNull AbstractVcs vcs) throws VcsException {
        VcsHistoryProvider historyProvider;
        if (pathBeforeRename == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(13);
        }
        if (vcs == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(14);
        }
        VcsHistorySession historySession = (historyProvider = vcs.getVcsHistoryProvider()) != null ? historyProvider.createSessionFor(pathBeforeRename) : null;
        List list = historySession == null ? Collections.emptyList() : historySession.getRevisionList();
        if (list == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    private static String parseVersionAsRevision(@NotNull String versionId, @NotNull AbstractVcs vcs) {
        Pattern revisionPattern;
        Matcher revisionMatcher;
        String vcsPattern;
        if (versionId == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(16);
        }
        if (vcs == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(17);
        }
        if ((vcsPattern = vcs.getRevisionPattern()) != null && (revisionMatcher = (revisionPattern = Pattern.compile(String.format(ourRevisionPatternTemplate, vcsPattern))).matcher(versionId)).find()) {
            return revisionMatcher.group(1);
        }
        return null;
    }

    private static void runWithModalProgressIfNeeded(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, @NotNull VcsRunnable task) throws VcsException {
        if (title == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(18);
        }
        if (task == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(19);
        }
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)task, (String)title, (boolean)true, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionId";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeRename";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/DefaultPatchBaseVersionProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/DefaultPatchBaseVersionProvider";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBaseVersionContent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadContentByRevisionId";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findContentInFileHistory";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRevisions";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionAsRevision";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runWithModalProgressIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }
}

