"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigManager = void 0;
const events_1 = require("events");
const configurationEventName = 'configuration-changed';
class ConfigManager {
    constructor() {
        this.emitter = new events_1.EventEmitter();
        this.config = {
            enable: true,
            assumeIsSvelteProject: false
        };
    }
    onConfigurationChanged(listener) {
        this.emitter.on(configurationEventName, listener);
    }
    removeConfigurationChangeListener(listener) {
        this.emitter.off(configurationEventName, listener);
    }
    isConfigChanged(config) {
        // right now we only care about enable
        return config.enable !== this.config.enable;
    }
    updateConfigFromPluginConfig(config) {
        // TODO this doesn't work because TS will resolve/load files already before we get the config request,
        // which leads to TS files that use Svelte files getting all kinds of type errors
        // const shouldWaitForConfigRequest = config.global == true;
        // const enable = config.enable ?? !shouldWaitForConfigRequest;
        this.config = {
            ...this.config,
            ...config
        };
        this.emitter.emit(configurationEventName, config);
    }
    getConfig() {
        return this.config;
    }
}
exports.ConfigManager = ConfigManager;
//# sourceMappingURL=config-manager.js.map