# Copyright 2020 The gVisor Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This script generates a golang file which contains:
#   * byte array with the sysmsg stub binary blob.
#   * set of variables with addresses of exported symbols.

#!/bin/bash

set -e
set -u

FILE=$1
NAME=$2

PREFIX=${NAME}_blob_offset__
BLOB=${NAME}_blob
OBJNAME=$3

AWK_CMD='$2 ~ /^[tBCTA]$/ { print "var '$PREFIX'" $3 " = 0x" $1 }'

cat << EOF
/* Autogenerated by $0, do not edit */
package sysmsg

EOF

nm "$OBJNAME" | grep "__export_" | tr . _ | awk "$AWK_CMD"
