# Contributing

```{toctree}
:maxdepth: 1

Coding Style <coding_style.md>
Gerrit Guidelines <gerrit_guidelines.md>
Commit Message Guidelines <git_commit_messages.md>
Project Ideas <project_ideas.md>
Documentation Ideas <documentation_ideas.md>
Google Summer of Code <gsoc.md>
```

The coreboot project uses the Developer Certificate of Origin as its
policy of accepting contributions. As such, a submitter bears the burden
that they have all necessary rights to submit their contribution to the
project under the project's licenses as appropriate. Violations of third
party rights will lead to the code's removal or replacement as suitable
to bring the project back into compliance.

This applies no matter under which circumstances a contribution has been
created: legal frameworks, work contracts, Generative Artificial
Intelligence ("AI") tooling, or other aspects that may affect the
ownership and copyright status of a contribution are outside the
project's control.

See the [Sign-off procedure] for more information.

[Sign-off procedure]: gerrit_guidelines.md#sign-off-procedure
