//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azquery

// AggregationType - the aggregation type of the metric.
type AggregationType string

const (
	AggregationTypeAverage AggregationType = "Average"
	AggregationTypeCount   AggregationType = "Count"
	AggregationTypeMaximum AggregationType = "Maximum"
	AggregationTypeMinimum AggregationType = "Minimum"
	AggregationTypeNone    AggregationType = "None"
	AggregationTypeTotal   AggregationType = "Total"
)

// PossibleAggregationTypeValues returns the possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{
		AggregationTypeAverage,
		AggregationTypeCount,
		AggregationTypeMaximum,
		AggregationTypeMinimum,
		AggregationTypeNone,
		AggregationTypeTotal,
	}
}

// BatchQueryRequestMethod - The method of a single request in a batch, defaults to POST
type BatchQueryRequestMethod string

const (
	BatchQueryRequestMethodPOST BatchQueryRequestMethod = "POST"
)

// PossibleBatchQueryRequestMethodValues returns the possible values for the BatchQueryRequestMethod const type.
func PossibleBatchQueryRequestMethodValues() []BatchQueryRequestMethod {
	return []BatchQueryRequestMethod{
		BatchQueryRequestMethodPOST,
	}
}

// BatchQueryRequestPath - The query path of a single request in a batch, defaults to /query
type BatchQueryRequestPath string

const (
	BatchQueryRequestPathQuery BatchQueryRequestPath = "/query"
)

// PossibleBatchQueryRequestPathValues returns the possible values for the BatchQueryRequestPath const type.
func PossibleBatchQueryRequestPathValues() []BatchQueryRequestPath {
	return []BatchQueryRequestPath{
		BatchQueryRequestPathQuery,
	}
}

// LogsColumnType - The data type of this column.
type LogsColumnType string

const (
	LogsColumnTypeBool     LogsColumnType = "bool"
	LogsColumnTypeDatetime LogsColumnType = "datetime"
	LogsColumnTypeDecimal  LogsColumnType = "decimal"
	LogsColumnTypeDynamic  LogsColumnType = "dynamic"
	LogsColumnTypeGUID     LogsColumnType = "guid"
	LogsColumnTypeInt      LogsColumnType = "int"
	LogsColumnTypeLong     LogsColumnType = "long"
	LogsColumnTypeReal     LogsColumnType = "real"
	LogsColumnTypeString   LogsColumnType = "string"
	LogsColumnTypeTimespan LogsColumnType = "timespan"
)

// PossibleLogsColumnTypeValues returns the possible values for the LogsColumnType const type.
func PossibleLogsColumnTypeValues() []LogsColumnType {
	return []LogsColumnType{
		LogsColumnTypeBool,
		LogsColumnTypeDatetime,
		LogsColumnTypeDecimal,
		LogsColumnTypeDynamic,
		LogsColumnTypeGUID,
		LogsColumnTypeInt,
		LogsColumnTypeLong,
		LogsColumnTypeReal,
		LogsColumnTypeString,
		LogsColumnTypeTimespan,
	}
}

// MetricClass - The class of the metric.
type MetricClass string

const (
	MetricClassAvailability MetricClass = "Availability"
	MetricClassErrors       MetricClass = "Errors"
	MetricClassLatency      MetricClass = "Latency"
	MetricClassSaturation   MetricClass = "Saturation"
	MetricClassTransactions MetricClass = "Transactions"
)

// PossibleMetricClassValues returns the possible values for the MetricClass const type.
func PossibleMetricClassValues() []MetricClass {
	return []MetricClass{
		MetricClassAvailability,
		MetricClassErrors,
		MetricClassLatency,
		MetricClassSaturation,
		MetricClassTransactions,
	}
}

// MetricUnit - The unit of the metric.
type MetricUnit string

const (
	MetricUnitBitsPerSecond  MetricUnit = "BitsPerSecond"
	MetricUnitByteSeconds    MetricUnit = "ByteSeconds"
	MetricUnitBytes          MetricUnit = "Bytes"
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	MetricUnitCores          MetricUnit = "Cores"
	MetricUnitCount          MetricUnit = "Count"
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	MetricUnitMilliCores     MetricUnit = "MilliCores"
	MetricUnitMilliSeconds   MetricUnit = "MilliSeconds"
	MetricUnitNanoCores      MetricUnit = "NanoCores"
	MetricUnitPercent        MetricUnit = "Percent"
	MetricUnitSeconds        MetricUnit = "Seconds"
	MetricUnitUnspecified    MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBitsPerSecond,
		MetricUnitByteSeconds,
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCores,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitMilliCores,
		MetricUnitMilliSeconds,
		MetricUnitNanoCores,
		MetricUnitPercent,
		MetricUnitSeconds,
		MetricUnitUnspecified,
	}
}

// NamespaceClassification - Kind of namespace
type NamespaceClassification string

const (
	NamespaceClassificationCustom   NamespaceClassification = "Custom"
	NamespaceClassificationPlatform NamespaceClassification = "Platform"
	NamespaceClassificationQos      NamespaceClassification = "Qos"
)

// PossibleNamespaceClassificationValues returns the possible values for the NamespaceClassification const type.
func PossibleNamespaceClassificationValues() []NamespaceClassification {
	return []NamespaceClassification{
		NamespaceClassificationCustom,
		NamespaceClassificationPlatform,
		NamespaceClassificationQos,
	}
}

// ResultType - Reduces the set of data collected. The syntax allowed depends on the operation. See the operation's description for details.
type ResultType string

const (
	ResultTypeData     ResultType = "Data"
	ResultTypeMetadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns the possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{
		ResultTypeData,
		ResultTypeMetadata,
	}
}
