//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/confluent/armconfluent"
	"net/http"
	"net/url"
	"regexp"
)

// AccessServer is a fake server for instances of the armconfluent.AccessClient type.
type AccessServer struct {
	// InviteUser is the fake for method AccessClient.InviteUser
	// HTTP status codes to indicate success: http.StatusOK
	InviteUser func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.AccessInviteUserAccountModel, options *armconfluent.AccessClientInviteUserOptions) (resp azfake.Responder[armconfluent.AccessClientInviteUserResponse], errResp azfake.ErrorResponder)

	// ListClusters is the fake for method AccessClient.ListClusters
	// HTTP status codes to indicate success: http.StatusOK
	ListClusters func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.ListAccessRequestModel, options *armconfluent.AccessClientListClustersOptions) (resp azfake.Responder[armconfluent.AccessClientListClustersResponse], errResp azfake.ErrorResponder)

	// ListEnvironments is the fake for method AccessClient.ListEnvironments
	// HTTP status codes to indicate success: http.StatusOK
	ListEnvironments func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.ListAccessRequestModel, options *armconfluent.AccessClientListEnvironmentsOptions) (resp azfake.Responder[armconfluent.AccessClientListEnvironmentsResponse], errResp azfake.ErrorResponder)

	// ListInvitations is the fake for method AccessClient.ListInvitations
	// HTTP status codes to indicate success: http.StatusOK
	ListInvitations func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.ListAccessRequestModel, options *armconfluent.AccessClientListInvitationsOptions) (resp azfake.Responder[armconfluent.AccessClientListInvitationsResponse], errResp azfake.ErrorResponder)

	// ListRoleBindings is the fake for method AccessClient.ListRoleBindings
	// HTTP status codes to indicate success: http.StatusOK
	ListRoleBindings func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.ListAccessRequestModel, options *armconfluent.AccessClientListRoleBindingsOptions) (resp azfake.Responder[armconfluent.AccessClientListRoleBindingsResponse], errResp azfake.ErrorResponder)

	// ListServiceAccounts is the fake for method AccessClient.ListServiceAccounts
	// HTTP status codes to indicate success: http.StatusOK
	ListServiceAccounts func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.ListAccessRequestModel, options *armconfluent.AccessClientListServiceAccountsOptions) (resp azfake.Responder[armconfluent.AccessClientListServiceAccountsResponse], errResp azfake.ErrorResponder)

	// ListUsers is the fake for method AccessClient.ListUsers
	// HTTP status codes to indicate success: http.StatusOK
	ListUsers func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.ListAccessRequestModel, options *armconfluent.AccessClientListUsersOptions) (resp azfake.Responder[armconfluent.AccessClientListUsersResponse], errResp azfake.ErrorResponder)
}

// NewAccessServerTransport creates a new instance of AccessServerTransport with the provided implementation.
// The returned AccessServerTransport instance is connected to an instance of armconfluent.AccessClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessServerTransport(srv *AccessServer) *AccessServerTransport {
	return &AccessServerTransport{srv: srv}
}

// AccessServerTransport connects instances of armconfluent.AccessClient to instances of AccessServer.
// Don't use this type directly, use NewAccessServerTransport instead.
type AccessServerTransport struct {
	srv *AccessServer
}

// Do implements the policy.Transporter interface for AccessServerTransport.
func (a *AccessServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessClient.InviteUser":
		resp, err = a.dispatchInviteUser(req)
	case "AccessClient.ListClusters":
		resp, err = a.dispatchListClusters(req)
	case "AccessClient.ListEnvironments":
		resp, err = a.dispatchListEnvironments(req)
	case "AccessClient.ListInvitations":
		resp, err = a.dispatchListInvitations(req)
	case "AccessClient.ListRoleBindings":
		resp, err = a.dispatchListRoleBindings(req)
	case "AccessClient.ListServiceAccounts":
		resp, err = a.dispatchListServiceAccounts(req)
	case "AccessClient.ListUsers":
		resp, err = a.dispatchListUsers(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessServerTransport) dispatchInviteUser(req *http.Request) (*http.Response, error) {
	if a.srv.InviteUser == nil {
		return nil, &nonRetriableError{errors.New("fake for method InviteUser not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/organizations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/access/default/createInvitation`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.AccessInviteUserAccountModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.InviteUser(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InvitationRecord, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessServerTransport) dispatchListClusters(req *http.Request) (*http.Response, error) {
	if a.srv.ListClusters == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListClusters not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/organizations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/access/default/listClusters`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.ListAccessRequestModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListClusters(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessListClusterSuccessResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessServerTransport) dispatchListEnvironments(req *http.Request) (*http.Response, error) {
	if a.srv.ListEnvironments == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListEnvironments not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/organizations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/access/default/listEnvironments`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.ListAccessRequestModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListEnvironments(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessListEnvironmentsSuccessResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessServerTransport) dispatchListInvitations(req *http.Request) (*http.Response, error) {
	if a.srv.ListInvitations == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListInvitations not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/organizations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/access/default/listInvitations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.ListAccessRequestModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListInvitations(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessListInvitationsSuccessResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessServerTransport) dispatchListRoleBindings(req *http.Request) (*http.Response, error) {
	if a.srv.ListRoleBindings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListRoleBindings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/organizations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/access/default/listRoleBindings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.ListAccessRequestModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListRoleBindings(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessListRoleBindingsSuccessResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessServerTransport) dispatchListServiceAccounts(req *http.Request) (*http.Response, error) {
	if a.srv.ListServiceAccounts == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListServiceAccounts not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/organizations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/access/default/listServiceAccounts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.ListAccessRequestModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListServiceAccounts(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessListServiceAccountsSuccessResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessServerTransport) dispatchListUsers(req *http.Request) (*http.Response, error) {
	if a.srv.ListUsers == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListUsers not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/organizations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/access/default/listUsers`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.ListAccessRequestModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListUsers(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessListUsersSuccessResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
