//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import "time"

// Alert - An individual alert.
type Alert struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// Alert properties.
	Properties *AlertProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AlertProperties - Alert properties.
type AlertProperties struct {
	// dateTime in which alert was closed
	CloseTime *string

	// related budget
	CostEntityID *string

	// dateTime in which alert was created
	CreationTime *string

	// defines the type of alert
	Definition *AlertPropertiesDefinition

	// Alert description
	Description *string

	// Alert details
	Details *AlertPropertiesDetails

	// dateTime in which alert was last modified
	ModificationTime *string

	// Source of alert
	Source *AlertSource

	// alert status
	Status *AlertStatus

	// dateTime in which the alert status was last modified
	StatusModificationTime *string

	// User who last modified the alert
	StatusModificationUserName *string
}

// AlertPropertiesDefinition - defines the type of alert
type AlertPropertiesDefinition struct {
	// Alert category
	Category *AlertCategory

	// Criteria that triggered alert
	Criteria *AlertCriteria

	// type of alert
	Type *AlertType
}

// AlertPropertiesDetails - Alert details
type AlertPropertiesDetails struct {
	// budget threshold amount
	Amount *float64

	// company name
	CompanyName *string

	// list of emails to contact
	ContactEmails []*string

	// list of action groups to broadcast to
	ContactGroups []*string

	// list of contact roles
	ContactRoles []*string

	// current spend
	CurrentSpend *float64

	// department name
	DepartmentName *string

	// datetime of enrollmentEndDate
	EnrollmentEndDate *string

	// enrollment number
	EnrollmentNumber *string

	// datetime of enrollmentStartDate
	EnrollmentStartDate *string

	// invoicing threshold
	InvoicingThreshold *float64

	// array of meters to filter by
	MeterFilter []any

	// operator used to compare currentSpend with amount
	Operator *AlertOperator

	// overriding alert
	OverridingAlert *string

	// datetime of periodStartDate
	PeriodStartDate *string

	// array of resources to filter by
	ResourceFilter []any

	// array of resourceGroups to filter by
	ResourceGroupFilter []any

	// tags to filter by
	TagFilter any

	// notification threshold percentage as a decimal which activated this alert
	Threshold *float64

	// Type of timegrain cadence
	TimeGrainType *AlertTimeGrainType

	// notificationId that triggered this alert
	TriggeredBy *string

	// unit of currency being used
	Unit *string
}

// AlertsResult - Result of alerts.
type AlertsResult struct {
	// READ-ONLY; URL to get the next set of alerts results if there are any.
	NextLink *string

	// READ-ONLY; List of alerts.
	Value []*Alert
}

// AllSavingsBenefitDetails - Benefit recommendation details.
type AllSavingsBenefitDetails struct {
	// READ-ONLY; Estimated average utilization percentage for the 'totalHours' in the look-back period, with this commitment.
	AverageUtilizationPercentage *float64

	// READ-ONLY; The estimated cost with benefit for the 'totalHours' in the look-back period. It's equal to (commitmentAmount
	// * totalHours)
	BenefitCost *float64

	// READ-ONLY; The commitment amount at the commitmentGranularity.
	CommitmentAmount *float64

	// READ-ONLY; Estimated benefit coverage percentage for the 'totalHours' in the look-back period, with this commitment.
	CoveragePercentage *float64

	// READ-ONLY; The difference between total cost and benefit cost for the 'totalHours' in the look-back period.
	OverageCost *float64

	// READ-ONLY; The amount saved for the 'totalHours' in the look-back period, by purchasing the recommended quantity of the
	// benefit.
	SavingsAmount *float64

	// READ-ONLY; The savings in percentage for the 'totalHours' in the look-back period, by purchasing the recommended quantity
	// of benefit.
	SavingsPercentage *float64

	// READ-ONLY; Total cost, which is sum of benefit cost and overage cost.
	TotalCost *float64

	// READ-ONLY; Estimated unused portion of the 'benefitCost'.
	WastageCost *float64
}

// AllSavingsList - The list of all benefit recommendations with the recommendation details.
type AllSavingsList struct {
	// READ-ONLY; The link (URL) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of benefit recommendations with the recommendation details..
	Value []*AllSavingsBenefitDetails
}

// BenefitRecommendationModel - benefit plan recommendation details.
type BenefitRecommendationModel struct {
	// Reservation or SavingsPlan.
	Kind *BenefitKind

	// The properties of the benefit recommendations.
	Properties BenefitRecommendationPropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BenefitRecommendationProperties - The properties of the benefit recommendations.
type BenefitRecommendationProperties struct {
	// REQUIRED; Benefit scope. For example, Single or Shared.
	Scope *Scope

	// Grain of the proposed commitment amount. Supported values: 'Hourly'
	CommitmentGranularity *Grain

	// The number of days of usage evaluated for computing the recommendations.
	LookBackPeriod *LookBackPeriod

	// The details of the proposed recommendation.
	RecommendationDetails *AllSavingsBenefitDetails

	// Term period of the benefit. For example, P1Y or P3Y.
	Term *Term

	// On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations.
	Usage *RecommendationUsageDetails

	// READ-ONLY; The list of all benefit recommendations with the recommendation details.
	AllRecommendationDetails *AllSavingsList

	// READ-ONLY; ARM SKU name. 'ComputeSavingsPlan' for SavingsPlan.
	ArmSKUName *string

	// READ-ONLY; The current cost without benefit, corresponds to 'totalHours' in the look-back period.
	CostWithoutBenefit *float64

	// READ-ONLY; An ISO 4217 currency code identifier for the costs and savings amounts.
	CurrencyCode *string

	// READ-ONLY; The first usage date used for looking back for computing the recommendations.
	FirstConsumptionDate *time.Time

	// READ-ONLY; The last usage date used for looking back for computing the recommendations.
	LastConsumptionDate *time.Time

	// READ-ONLY; The total hours for which the cost is covered. Its equal to number of records in a property 'properties/usage/charges'.
	TotalHours *int32
}

// GetBenefitRecommendationProperties implements the BenefitRecommendationPropertiesClassification interface for type BenefitRecommendationProperties.
func (b *BenefitRecommendationProperties) GetBenefitRecommendationProperties() *BenefitRecommendationProperties {
	return b
}

// BenefitRecommendationsListResult - Result of listing benefit recommendations.
type BenefitRecommendationsListResult struct {
	// READ-ONLY; The link (URL) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of benefit recommendations.
	Value []*BenefitRecommendationModel
}

// BenefitUtilizationSummariesListResult - List of benefit utilization summaries.
type BenefitUtilizationSummariesListResult struct {
	// READ-ONLY; The link (URL) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of benefit utilization summaries.
	Value []BenefitUtilizationSummaryClassification
}

// BenefitUtilizationSummary - Benefit utilization summary resource.
type BenefitUtilizationSummary struct {
	// REQUIRED; Supported values: 'SavingsPlan'.
	Kind *BenefitKind

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetBenefitUtilizationSummary implements the BenefitUtilizationSummaryClassification interface for type BenefitUtilizationSummary.
func (b *BenefitUtilizationSummary) GetBenefitUtilizationSummary() *BenefitUtilizationSummary {
	return b
}

// BlobInfo - The blob information generated by this operation.
type BlobInfo struct {
	// Link to the blob to download file.
	BlobLink *string

	// Bytes in the blob.
	ByteCount *int64
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string

	// The resource type.
	Type *string
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string

	// Indicates if the resource name is available.
	NameAvailable *bool

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason
}

// CommonExportProperties - The common properties of the export.
type CommonExportProperties struct {
	// REQUIRED; Has the definition for the export.
	Definition *ExportDefinition

	// REQUIRED; Has delivery information for the export.
	DeliveryInfo *ExportDeliveryInfo

	// The format of the export being delivered. Currently only 'Csv' is supported.
	Format *FormatType

	// If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file.
	// Note: this option is currently available only for Microsoft Customer Agreement
	// commerce scopes.
	PartitionData *bool

	// If requested, has the most recent run history for the export.
	RunHistory *ExportExecutionListResult

	// READ-ONLY; If the export has an active schedule, provides an estimate of the next run time.
	NextRunTimeEstimate *time.Time
}

// CostDetailsOperationResults - The result of the long running operation for cost details Api.
type CostDetailsOperationResults struct {
	// The details of the error.
	Error *ErrorDetails

	// The id of the long running operation.
	ID *string

	// The manifest of the report generated by the operation.
	Manifest *ReportManifest

	// The name of the long running operation.
	Name *string

	// The status of the cost details operation
	Status *CostDetailsStatusType

	// The type of the long running operation.
	Type *string

	// The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z.
	ValidTill *time.Time
}

// CostDetailsTimePeriod - The start and end date for pulling data for the cost detailed report. API only allows data to be
// pulled for 1 month or less and no older than 13 months.
type CostDetailsTimePeriod struct {
	// REQUIRED; The end date to pull data to. example format 2020-03-15
	End *string

	// REQUIRED; The start date to pull data from. example format 2020-03-15
	Start *string
}

// Dimension - List of Dimension.
type Dimension struct {
	// Dimension properties.
	Properties *DimensionProperties

	// READ-ONLY; ETag of the resource.
	ETag *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Location of the resource.
	Location *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; SKU of the resource.
	SKU *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// DimensionProperties - Dimension properties.
type DimensionProperties struct {
	// Dimension data.
	Data []*string

	// READ-ONLY; Dimension category.
	Category *string

	// READ-ONLY; Dimension description.
	Description *string

	// READ-ONLY; Filter enabled.
	FilterEnabled *bool

	// READ-ONLY; Grouping enabled.
	GroupingEnabled *bool

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Total number of data for the dimension.
	Total *int32

	// READ-ONLY; Usage end.
	UsageEnd *time.Time

	// READ-ONLY; Usage start.
	UsageStart *time.Time
}

// DimensionsListResult - Result of listing dimensions. It contains a list of available dimensions.
type DimensionsListResult struct {
	// READ-ONLY; The list of dimensions.
	Value []*Dimension
}

// DismissAlertPayload - The request payload to update an alert
type DismissAlertPayload struct {
	// Alert properties.
	Properties *AlertProperties
}

// DownloadURL - The URL to download the generated report.
type DownloadURL struct {
	// The URL to download the generated report.
	DownloadURL *string

	// The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z.
	ValidTill *time.Time

	// READ-ONLY; The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z.
	ExpiryTime *time.Time
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// Export - An export resource.
type Export struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// The properties of the export.
	Properties *ExportProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExportDataset - The definition for data in the export.
type ExportDataset struct {
	// The export dataset configuration.
	Configuration *ExportDatasetConfiguration

	// The granularity of rows in the export. Currently only 'Daily' is supported.
	Granularity *GranularityType
}

// ExportDatasetConfiguration - The export dataset configuration. Allows columns to be selected for the export. If not provided
// then the export will include all available columns.
type ExportDatasetConfiguration struct {
	// Array of column names to be included in the export. If not provided then the export will include all available columns.
	// The available columns can vary by customer channel (see examples).
	Columns []*string
}

// ExportDefinition - The definition of an export.
type ExportDefinition struct {
	// REQUIRED; The time frame for pulling data for the export. If custom, then a specific time period must be provided.
	Timeframe *TimeframeType

	// REQUIRED; The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do
	// not yet provide data for charges or amortization for service reservations.
	Type *ExportType

	// The definition for data in the export.
	DataSet *ExportDataset

	// Has time period for pulling data for the export.
	TimePeriod *ExportTimePeriod
}

// ExportDeliveryDestination - This represents the blob storage account location where exports of costs will be delivered.
// There are two ways to configure the destination. The approach recommended for most customers is to specify
// the resourceId of the storage account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports
// resource provider in order to give Cost Management
// services access to the storage. When creating an export in the Azure portal this registration is performed automatically
// but API users may need to register the subscription explicitly (for more
// information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another
// way to configure the destination is available ONLY to Partners with a
// Microsoft Partner Agreement plan who are global admins of their billing account. These Partners, instead of specifying
// the resourceId of a storage account, can specify the storage account name along
// with a SAS token for the account. This allows exports of costs to a storage account in any tenant. The SAS token should
// be created for the blob service with Service/Container/Object resource types and
// with Read/Write/Delete/List/Add/Create permissions (for more information see https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key
// ).
type ExportDeliveryDestination struct {
	// REQUIRED; The name of the container where exports will be uploaded. If the container does not exist it will be created.
	Container *string

	// The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount
	// are specified.
	ResourceID *string

	// The name of the directory where exports will be uploaded.
	RootFolderPath *string

	// A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified
	// instead of resourceId. Note: the value returned by the API for this
	// property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated.
	// To update this value a new SAS token must be specified.
	SasToken *string

	// The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken
	// can be specified instead of resourceId.
	StorageAccount *string
}

// ExportDeliveryInfo - The delivery information associated with a export.
type ExportDeliveryInfo struct {
	// REQUIRED; Has destination for the export being delivered.
	Destination *ExportDeliveryDestination
}

// ExportExecutionListResult - Result of listing the run history of an export.
type ExportExecutionListResult struct {
	// READ-ONLY; A list of export runs.
	Value []*ExportRun
}

// ExportListResult - Result of listing exports. It contains a list of available exports in the scope provided.
type ExportListResult struct {
	// READ-ONLY; The list of exports.
	Value []*Export
}

// ExportProperties - The properties of the export.
type ExportProperties struct {
	// REQUIRED; Has the definition for the export.
	Definition *ExportDefinition

	// REQUIRED; Has delivery information for the export.
	DeliveryInfo *ExportDeliveryInfo

	// The format of the export being delivered. Currently only 'Csv' is supported.
	Format *FormatType

	// If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file.
	// Note: this option is currently available only for Microsoft Customer Agreement
	// commerce scopes.
	PartitionData *bool

	// If requested, has the most recent run history for the export.
	RunHistory *ExportExecutionListResult

	// Has schedule information for the export.
	Schedule *ExportSchedule

	// READ-ONLY; If the export has an active schedule, provides an estimate of the next run time.
	NextRunTimeEstimate *time.Time
}

// ExportRecurrencePeriod - The start and end date for recurrence schedule.
type ExportRecurrencePeriod struct {
	// REQUIRED; The start date of recurrence.
	From *time.Time

	// The end date of recurrence.
	To *time.Time
}

// ExportRun - An export run.
type ExportRun struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// The properties of the export run.
	Properties *ExportRunProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExportRunProperties - The properties of the export run.
type ExportRunProperties struct {
	// The details of any error.
	Error *ErrorDetails

	// The type of the export run.
	ExecutionType *ExecutionType

	// The name of the exported file.
	FileName *string

	// The time when the export run finished.
	ProcessingEndTime *time.Time

	// The time when export was picked up to be run.
	ProcessingStartTime *time.Time

	// The export settings that were in effect for this run.
	RunSettings *CommonExportProperties

	// The last known status of the export run.
	Status *ExecutionStatus

	// The identifier for the entity that triggered the export. For on-demand runs it is the user email. For scheduled runs it
	// is 'System'.
	SubmittedBy *string

	// The time when export was queued to be run.
	SubmittedTime *time.Time
}

// ExportSchedule - The schedule associated with the export.
type ExportSchedule struct {
	// The schedule recurrence.
	Recurrence *RecurrenceType

	// Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than
	// start date.
	RecurrencePeriod *ExportRecurrencePeriod

	// The status of the export's schedule. If 'Inactive', the export's schedule is paused.
	Status *StatusType
}

// ExportTimePeriod - The date range for data in the export. This should only be specified with timeFrame set to 'Custom'.
// The maximum date range is 3 months.
type ExportTimePeriod struct {
	// REQUIRED; The start date for export data.
	From *time.Time

	// REQUIRED; The end date for export data.
	To *time.Time
}

// FileDestination - Destination of the view data. This is optional. Currently only CSV format is supported.
type FileDestination struct {
	// Destination of the view data. Currently only CSV format is supported.
	FileFormats []*FileFormat
}

// ForecastAggregation - The aggregation expression to be used in the forecast.
type ForecastAggregation struct {
	// REQUIRED; The name of the aggregation function to use.
	Function *FunctionType

	// REQUIRED; The name of the column to aggregate.
	Name *FunctionName
}

// ForecastColumn - Forecast column properties
type ForecastColumn struct {
	// The name of column.
	Name *string

	// The type of column.
	Type *string
}

// ForecastComparisonExpression - The comparison expression to be used in the forecast.
type ForecastComparisonExpression struct {
	// REQUIRED; The name of the column to use in comparison.
	Name *string

	// REQUIRED; The operator to use for comparison.
	Operator *ForecastOperatorType

	// REQUIRED; Array of values to use for comparison
	Values []*string
}

// ForecastDataset - The definition of data present in the forecast.
type ForecastDataset struct {
	// REQUIRED; Dictionary of aggregation expression to use in the forecast. The key of each item in the dictionary is the alias
	// for the aggregated column. forecast can have up to 2 aggregation clauses.
	Aggregation map[string]*ForecastAggregation

	// Has configuration information for the data in the export. The configuration will be ignored if aggregation and grouping
	// are provided.
	Configuration *ForecastDatasetConfiguration

	// Has filter expression to use in the forecast.
	Filter *ForecastFilter

	// The granularity of rows in the forecast.
	Granularity *GranularityType
}

// ForecastDatasetConfiguration - The configuration of dataset in the forecast.
type ForecastDatasetConfiguration struct {
	// Array of column names to be included in the forecast. Any valid forecast column name is allowed. If not provided, then
	// forecast includes all columns.
	Columns []*string
}

// ForecastDefinition - The definition of a forecast.
type ForecastDefinition struct {
	// REQUIRED; Has definition for data in this forecast.
	Dataset *ForecastDataset

	// REQUIRED; The time frame for pulling data for the forecast. If custom, then a specific time period must be provided.
	Timeframe *ForecastTimeframe

	// REQUIRED; The type of the forecast.
	Type *ForecastType

	// A boolean determining if actualCost will be included.
	IncludeActualCost *bool

	// A boolean determining if FreshPartialCost will be included.
	IncludeFreshPartialCost *bool

	// Has time period for pulling data for the forecast.
	TimePeriod *ForecastTimePeriod
}

// ForecastFilter - The filter expression to be used in the export.
type ForecastFilter struct {
	// The logical "AND" expression. Must have at least 2 items.
	And []*ForecastFilter

	// Has comparison expression for a dimension
	Dimensions *ForecastComparisonExpression

	// The logical "OR" expression. Must have at least 2 items.
	Or []*ForecastFilter

	// Has comparison expression for a tag
	Tags *ForecastComparisonExpression
}

// ForecastProperties - Forecast properties
type ForecastProperties struct {
	// Array of columns
	Columns []*ForecastColumn

	// The link (url) to the next page of results.
	NextLink *string

	// Array of rows
	Rows [][]any
}

// ForecastResult - Result of forecast. It contains all columns listed under groupings and aggregation.
type ForecastResult struct {
	// Forecast properties
	Properties *ForecastProperties

	// READ-ONLY; ETag of the resource.
	ETag *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Location of the resource.
	Location *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; SKU of the resource.
	SKU *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// ForecastTimePeriod - Has time period for pulling data for the forecast.
type ForecastTimePeriod struct {
	// REQUIRED; The start date to pull data from.
	From *time.Time

	// REQUIRED; The end date to pull data to.
	To *time.Time
}

// GenerateCostDetailsReportRequestDefinition - The definition of a cost detailed report.
type GenerateCostDetailsReportRequestDefinition struct {
	// This parameter can be used only by Enterprise Agreement customers. Use the YearMonth(e.g. 202008) format. This parameter
	// cannot be used alongside either the invoiceId or timePeriod parameters. If a
	// timePeriod, invoiceId or billingPeriod parameter is not provided in the request body the API will return the current month's
	// cost.
	BillingPeriod *string

	// This parameter can only be used by Microsoft Customer Agreement customers. Additionally, it can only be used at the Billing
	// Profile or Customer scope. This parameter cannot be used alongside either
	// the billingPeriod or timePeriod parameters. If a timePeriod, invoiceId or billingPeriod parameter is not provided in the
	// request body the API will return the current month's cost.
	InvoiceID *string

	// The type of the detailed report. By default ActualCost is provided
	Metric *CostDetailsMetricType

	// The specific date range of cost details requested for the report. This parameter cannot be used alongside either the invoiceId
	// or billingPeriod parameters. If a timePeriod, invoiceId or billingPeriod
	// parameter is not provided in the request body the API will return the current month's cost. API only allows data to be
	// pulled for 1 month or less and no older than 13 months. If no timePeriod or
	// billingPeriod or invoiceId is provided the API defaults to the open month time period
	TimePeriod *CostDetailsTimePeriod
}

// GenerateDetailedCostReportDefinition - The definition of a cost detailed report.
type GenerateDetailedCostReportDefinition struct {
	// Billing period in YearMonth(e.g. 202008) format. Only for legacy enterprise customers can use this. Can only have one of
	// either timePeriod or invoiceId or billingPeriod parameters. If none provided
	// current month cost is provided.
	BillingPeriod *string

	// Customer ID for Microsoft Customer Agreement scopes (Invoice Id is also required for this).
	CustomerID *string

	// Invoice ID for Pay-as-you-go and Microsoft Customer Agreement scopes. Can only have one of either timePeriod or invoiceId
	// or billingPeriod parameters. If none provided current month cost is provided.
	InvoiceID *string

	// The type of the detailed report. By default ActualCost is provided
	Metric *GenerateDetailedCostReportMetricType

	// Has time period for pulling data for the cost detailed report. Can only have one of either timePeriod or invoiceId or billingPeriod
	// parameters. If none provided current month cost is provided.
	TimePeriod *GenerateDetailedCostReportTimePeriod
}

// GenerateDetailedCostReportOperationResult - The result of the long running operation for cost detailed report.
type GenerateDetailedCostReportOperationResult struct {
	// The ARM resource id of the long running operation.
	ID *string

	// The name of the long running operation.
	Name *string

	// The properties of the resource generated.
	Properties *DownloadURL

	// The type of the long running operation.
	Type *string
}

// GenerateDetailedCostReportOperationStatuses - The status of the long running operation for cost detailed report.
type GenerateDetailedCostReportOperationStatuses struct {
	// The endTime of the operation.
	EndTime *string

	// The details of the error.
	Error *ErrorDetails

	// The ID of the long running operation.
	ID *string

	// The name of the long running operation.
	Name *string

	// The properties of the usage file generated.
	Properties *DownloadURL

	// The startTime of the operation.
	StartTime *string

	// The status of the long running operation.
	Status *Status

	// The type of the long running operation.
	Type *string
}

// GenerateDetailedCostReportTimePeriod - The start and end date for pulling data for the cost detailed report.
type GenerateDetailedCostReportTimePeriod struct {
	// REQUIRED; The end date to pull data to. example format 2020-03-15
	End *string

	// REQUIRED; The start date to pull data from. example format 2020-03-15
	Start *string
}

// IncludedQuantityUtilizationSummary - Included Quantity utilization summary resource.
type IncludedQuantityUtilizationSummary struct {
	// REQUIRED; Supported values: 'SavingsPlan'.
	Kind *BenefitKind

	// Included Quantity utilization summary properties.
	Properties *IncludedQuantityUtilizationSummaryProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetBenefitUtilizationSummary implements the BenefitUtilizationSummaryClassification interface for type IncludedQuantityUtilizationSummary.
func (i *IncludedQuantityUtilizationSummary) GetBenefitUtilizationSummary() *BenefitUtilizationSummary {
	return &BenefitUtilizationSummary{
		ID:   i.ID,
		Kind: i.Kind,
		Name: i.Name,
		Type: i.Type,
	}
}

// IncludedQuantityUtilizationSummaryProperties - Included Quantity utilization summary properties.
type IncludedQuantityUtilizationSummaryProperties struct {
	// The benefit type. Supported values: 'SavingsPlan'.
	BenefitType *BenefitKind

	// READ-ONLY; ARM SKU name. For example, 'ComputeSavingsPlan' for savings plan.
	ArmSKUName *string

	// READ-ONLY; The benefit ID is the identifier of the benefit.
	BenefitID *string

	// READ-ONLY; The benefit order ID is the identifier for a benefit purchase.
	BenefitOrderID *string

	// READ-ONLY; Date corresponding to the utilization summary record. If the grain of data is monthly, value for this field
	// will be first day of the month.
	UsageDate *time.Time

	// READ-ONLY; This is the utilized percentage for the benefit ID.
	UtilizationPercentage *float64
}

// KpiProperties - Each KPI must contain a 'type' and 'enabled' key.
type KpiProperties struct {
	// show the KPI in the UI?
	Enabled *bool

	// ID of resource related to metric (budget).
	ID *string

	// KPI type (Forecast, Budget).
	Type *KpiType
}

// NotificationProperties - The properties of the scheduled action notification.
type NotificationProperties struct {
	// REQUIRED; Subject of the email. Length is limited to 70 characters.
	Subject *string

	// REQUIRED; Array of email addresses.
	To []*string

	// Locale of the email.
	Language *string

	// Optional message to be added in the email. Length is limited to 250 characters.
	Message *string

	// Regional format used for formatting date/time and currency values in the email.
	RegionalFormat *string
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationForCostManagement - A Cost management REST API operation.
type OperationForCostManagement struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Operation id: {provider}/{resource}/{operation}.
	ID *string

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationListResult - Result of listing cost management operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of cost management operations supported by the Microsoft.CostManagement resource provider.
	Value []*OperationForCostManagement
}

// OperationStatus - The status of the long running operation.
type OperationStatus struct {
	// The properties of the resource generated.
	Properties *ReportURL

	// The status of the long running operation.
	Status *OperationStatusType
}

// PivotProperties - Each pivot must contain a 'type' and 'name'.
type PivotProperties struct {
	// Data field to show in view.
	Name *string

	// Data type to show in view.
	Type *PivotType
}

// QueryAggregation - The aggregation expression to be used in the query.
type QueryAggregation struct {
	// REQUIRED; The name of the aggregation function to use.
	Function *FunctionType

	// REQUIRED; The name of the column to aggregate.
	Name *string
}

// QueryColumn properties
type QueryColumn struct {
	// The name of column.
	Name *string

	// The type of column.
	Type *string
}

// QueryComparisonExpression - The comparison expression to be used in the query.
type QueryComparisonExpression struct {
	// REQUIRED; The name of the column to use in comparison.
	Name *string

	// REQUIRED; The operator to use for comparison.
	Operator *QueryOperatorType

	// REQUIRED; Array of values to use for comparison
	Values []*string
}

// QueryDataset - The definition of data present in the query.
type QueryDataset struct {
	// Dictionary of aggregation expression to use in the query. The key of each item in the dictionary is the alias for the aggregated
	// column. Query can have up to 2 aggregation clauses.
	Aggregation map[string]*QueryAggregation

	// Has configuration information for the data in the export. The configuration will be ignored if aggregation and grouping
	// are provided.
	Configuration *QueryDatasetConfiguration

	// The filter expression to use in the query. Please reference our Query API REST documentation for how to properly format
	// the filter.
	Filter *QueryFilter

	// The granularity of rows in the query.
	Granularity *GranularityType

	// Array of group by expression to use in the query. Query can have up to 2 group by clauses.
	Grouping []*QueryGrouping
}

// QueryDatasetConfiguration - The configuration of dataset in the query.
type QueryDatasetConfiguration struct {
	// Array of column names to be included in the query. Any valid query column name is allowed. If not provided, then query
	// includes all columns.
	Columns []*string
}

// QueryDefinition - The definition of a query.
type QueryDefinition struct {
	// REQUIRED; Has definition for data in this query.
	Dataset *QueryDataset

	// REQUIRED; The time frame for pulling data for the query. If custom, then a specific time period must be provided.
	Timeframe *TimeframeType

	// REQUIRED; The type of the query.
	Type *ExportType

	// Has time period for pulling data for the query.
	TimePeriod *QueryTimePeriod
}

// QueryFilter - The filter expression to be used in the export.
type QueryFilter struct {
	// The logical "AND" expression. Must have at least 2 items.
	And []*QueryFilter

	// Has comparison expression for a dimension
	Dimensions *QueryComparisonExpression

	// The logical "OR" expression. Must have at least 2 items.
	Or []*QueryFilter

	// Has comparison expression for a tag
	Tags *QueryComparisonExpression
}

// QueryGrouping - The group by expression to be used in the query.
type QueryGrouping struct {
	// REQUIRED; The name of the column to group.
	Name *string

	// REQUIRED; Has type of the column to group.
	Type *QueryColumnType
}

// QueryProperties - Query properties
type QueryProperties struct {
	// Array of columns
	Columns []*QueryColumn

	// The link (url) to the next page of results.
	NextLink *string

	// Array of rows
	Rows [][]any
}

// QueryResult - Result of query. It contains all columns listed under groupings and aggregation.
type QueryResult struct {
	// Query properties
	Properties *QueryProperties

	// READ-ONLY; ETag of the resource.
	ETag *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Location of the resource.
	Location *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; SKU of the resource.
	SKU *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// QueryTimePeriod - The start and end date for pulling data for the query.
type QueryTimePeriod struct {
	// REQUIRED; The start date to pull data from.
	From *time.Time

	// REQUIRED; The end date to pull data to.
	To *time.Time
}

// RecommendationUsageDetails - On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for
// computing benefit recommendations.
type RecommendationUsageDetails struct {
	// The grain of the usage. Supported values: 'Hourly'
	UsageGrain *Grain

	// READ-ONLY; On-demand charges for each hour between firstConsumptionDate and lastConsumptionDate that were used for computing
	// benefit recommendations.
	Charges []*float64
}

// ReportConfigAggregation - The aggregation expression to be used in the report.
type ReportConfigAggregation struct {
	// REQUIRED; The name of the aggregation function to use.
	Function *FunctionType

	// REQUIRED; The name of the column to aggregate.
	Name *string
}

// ReportConfigComparisonExpression - The comparison expression to be used in the report.
type ReportConfigComparisonExpression struct {
	// REQUIRED; The name of the column to use in comparison.
	Name *string

	// REQUIRED; The operator to use for comparison.
	Operator *OperatorType

	// REQUIRED; Array of values to use for comparison
	Values []*string
}

// ReportConfigDataset - The definition of data present in the report.
type ReportConfigDataset struct {
	// Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the
	// aggregated column. Report can have up to 2 aggregation clauses.
	Aggregation map[string]*ReportConfigAggregation

	// Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping
	// are provided.
	Configuration *ReportConfigDatasetConfiguration

	// Has filter expression to use in the report.
	Filter *ReportConfigFilter

	// The granularity of rows in the report.
	Granularity *ReportGranularityType

	// Array of group by expression to use in the report. Report can have up to 2 group by clauses.
	Grouping []*ReportConfigGrouping

	// Array of order by expression to use in the report.
	Sorting []*ReportConfigSorting
}

// ReportConfigDatasetConfiguration - The configuration of dataset in the report.
type ReportConfigDatasetConfiguration struct {
	// Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report
	// includes all columns.
	Columns []*string
}

// ReportConfigDefinition - The definition of a report config.
type ReportConfigDefinition struct {
	// REQUIRED; The time frame for pulling data for the report. If custom, then a specific time period must be provided.
	Timeframe *ReportTimeframeType

	// REQUIRED; The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast
	// represents both usage and forecasted data. Actual usage and forecasted data can be
	// differentiated based on dates.
	Type *ReportType

	// Has definition for data in this report config.
	DataSet *ReportConfigDataset

	// If true, report includes monetary commitment.
	IncludeMonetaryCommitment *bool

	// Has time period for pulling data for the report.
	TimePeriod *ReportConfigTimePeriod
}

// ReportConfigFilter - The filter expression to be used in the report.
type ReportConfigFilter struct {
	// The logical "AND" expression. Must have at least 2 items.
	And []*ReportConfigFilter

	// Has comparison expression for a dimension
	Dimensions *ReportConfigComparisonExpression

	// The logical "OR" expression. Must have at least 2 items.
	Or []*ReportConfigFilter

	// Has comparison expression for a tag
	Tags *ReportConfigComparisonExpression
}

// ReportConfigGrouping - The group by expression to be used in the report.
type ReportConfigGrouping struct {
	// REQUIRED; The name of the column to group. This version supports subscription lowest possible grain.
	Name *string

	// REQUIRED; Has type of the column to group.
	Type *QueryColumnType
}

// ReportConfigSorting - The order by expression to be used in the report.
type ReportConfigSorting struct {
	// REQUIRED; The name of the column to sort.
	Name *string

	// Direction of sort.
	Direction *ReportConfigSortingType
}

// ReportConfigTimePeriod - The start and end date for pulling data for the report.
type ReportConfigTimePeriod struct {
	// REQUIRED; The start date to pull data from.
	From *time.Time

	// REQUIRED; The end date to pull data to.
	To *time.Time
}

// ReportManifest - The manifest of the report generated by the operation.
type ReportManifest struct {
	// The total number of blobs.
	BlobCount *int32

	// List of blob information generated by this operation.
	Blobs []*BlobInfo

	// The total number of bytes in all blobs.
	ByteCount *int64

	// Is the data in compressed format.
	CompressData *bool

	// The data format of the report
	DataFormat *CostDetailsDataFormat

	// The Manifest version.
	ManifestVersion *string

	// The context of the Cost Details request.
	RequestContext *RequestContext
}

// ReportURL - The URL to download the generated report.
type ReportURL struct {
	// The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily granularity
	ReportURL *ReservationReportSchema

	// The time at which report URL becomes invalid.
	ValidUntil *time.Time
}

// RequestContext - The context of the Cost Details request.
type RequestContext struct {
	// The request payload body provided in Cost Details call
	RequestBody *GenerateCostDetailsReportRequestDefinition

	// The request scope of the request.
	RequestScope *string
}

// SavingsPlanUtilizationSummary - Savings plan utilization summary resource.
type SavingsPlanUtilizationSummary struct {
	// REQUIRED; Supported values: 'SavingsPlan'.
	Kind *BenefitKind

	// Savings plan utilization summary properties.
	Properties *SavingsPlanUtilizationSummaryProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetBenefitUtilizationSummary implements the BenefitUtilizationSummaryClassification interface for type SavingsPlanUtilizationSummary.
func (s *SavingsPlanUtilizationSummary) GetBenefitUtilizationSummary() *BenefitUtilizationSummary {
	return &BenefitUtilizationSummary{
		ID:   s.ID,
		Kind: s.Kind,
		Name: s.Name,
		Type: s.Type,
	}
}

// SavingsPlanUtilizationSummaryProperties - Savings plan utilization summary properties.
type SavingsPlanUtilizationSummaryProperties struct {
	// The benefit type. Supported values: 'SavingsPlan'.
	BenefitType *BenefitKind

	// READ-ONLY; ARM SKU name. For example, 'ComputeSavingsPlan' for savings plan.
	ArmSKUName *string

	// READ-ONLY; This is the average hourly utilization for each date range that corresponds to given grain (Daily, Monthly).
	// Suppose the API call is for usageDate > 2022-10-01 and usageDate < 2022-10-31 at a daily
	// granularity. There will be one record per benefit id for each day. For a single day, the avgUtilizationPercentage value
	// will be equal to the average of the set of values where the set contains 24
	// utilization percentage entries one for each hour in a specific day.
	AvgUtilizationPercentage *float64

	// READ-ONLY; The benefit ID is the identifier of the benefit.
	BenefitID *string

	// READ-ONLY; The benefit order ID is the identifier for a benefit purchase.
	BenefitOrderID *string

	// READ-ONLY; This is the maximum hourly utilization for each date range that corresponds to given grain (Daily, Monthly).
	// Suppose the API call is for usageDate > 2022-10-01 and usageDate < 2022-10-31 at a daily
	// granularity. There will be one record per benefit id for each day. For a single day, the maxUtilizationPercentage value
	// will be equal to the largest in the set of values where the set contains 24
	// utilization percentage entries one for each hour in a specific day. If on the day 2022-10-18, the largest utilization percentage
	// was 90% at hour 5, then the value for the maxUtilizationPercentage in
	// the response will be 90%.
	MaxUtilizationPercentage *float64

	// READ-ONLY; This is the minimum hourly utilization for each date range that corresponds to given grain (Daily, Monthly).
	// Suppose the API call is for usageDate > 2022-10-01 and usageDate < 2022-10-31 at a daily
	// granularity. There will be one record per benefit id for each day. For a single day, the minUtilizationPercentage value
	// will be equal to the smallest in the set of values where the set contains 24
	// utilization percentage entries one for each hour in a specific day. If on the day 2022-10-18, the lowest utilization percentage
	// was 10% at hour 4, then the value for the minUtilizationPercentage in
	// the response will be 10%.
	MinUtilizationPercentage *float64

	// READ-ONLY; Date corresponding to the utilization summary record. If the grain of data is monthly, value for this field
	// will be first day of the month.
	UsageDate *time.Time
}

// ScheduleProperties - The properties of the schedule.
type ScheduleProperties struct {
	// REQUIRED; The end date and time of the scheduled action (UTC).
	EndDate *time.Time

	// REQUIRED; Frequency of the schedule.
	Frequency *ScheduleFrequency

	// REQUIRED; The start date and time of the scheduled action (UTC).
	StartDate *time.Time

	// UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency
	// is Monthly and overrides weeksOfMonth or daysOfWeek.
	DayOfMonth *int32

	// Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly
	// or Monthly.
	DaysOfWeek []*DaysOfWeek

	// UTC time at which cost analysis data will be emailed.
	HourOfDay *int32

	// Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination
	// with daysOfWeek.
	WeeksOfMonth []*WeeksOfMonth
}

// ScheduledAction - Scheduled action definition.
type ScheduledAction struct {
	// Kind of the scheduled action.
	Kind *ScheduledActionKind

	// The properties of the scheduled action.
	Properties *ScheduledActionProperties

	// READ-ONLY; Resource Etag. For update calls, eTag is optional and can be specified to achieve optimistic concurrency. Fetch
	// the resource's eTag by doing a 'GET' call first and then including the latest eTag as
	// part of the request body or 'If-Match' header while performing the update. For create calls, eTag is not required.
	ETag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Kind of the scheduled action.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScheduledActionListResult - Scheduled actions list result. It contains a list of scheduled actions.
type ScheduledActionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of scheduled actions.
	Value []*ScheduledAction
}

// ScheduledActionProperties - The properties of the scheduled action.
type ScheduledActionProperties struct {
	// REQUIRED; Scheduled action name.
	DisplayName *string

	// REQUIRED; Notification properties based on scheduled action kind.
	Notification *NotificationProperties

	// REQUIRED; Schedule of the scheduled action.
	Schedule *ScheduleProperties

	// REQUIRED; Status of the scheduled action.
	Status *ScheduledActionStatus

	// REQUIRED; Cost analysis viewId used for scheduled action. For example, '/providers/Microsoft.CostManagement/views/swaggerExample'
	ViewID *string

	// Destination format of the view data. This is optional.
	FileDestination *FileDestination

	// Email address of the point of contact that should get the unsubscribe requests and notification emails.
	NotificationEmail *string

	// Cost Management scope like 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
	// for resourceGroup scope,
	// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}'
	// for Department
	// scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
	// scope,
	// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
	// scope,
	// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
	// scope,
	// '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope,
	// and
	// '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
	Scope *string
}

// SharedScopeBenefitRecommendationProperties - The properties of the benefit recommendation when scope is 'Shared'.
type SharedScopeBenefitRecommendationProperties struct {
	// REQUIRED; Benefit scope. For example, Single or Shared.
	Scope *Scope

	// Grain of the proposed commitment amount. Supported values: 'Hourly'
	CommitmentGranularity *Grain

	// The number of days of usage evaluated for computing the recommendations.
	LookBackPeriod *LookBackPeriod

	// The details of the proposed recommendation.
	RecommendationDetails *AllSavingsBenefitDetails

	// Term period of the benefit. For example, P1Y or P3Y.
	Term *Term

	// On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations.
	Usage *RecommendationUsageDetails

	// READ-ONLY; The list of all benefit recommendations with the recommendation details.
	AllRecommendationDetails *AllSavingsList

	// READ-ONLY; ARM SKU name. 'ComputeSavingsPlan' for SavingsPlan.
	ArmSKUName *string

	// READ-ONLY; The current cost without benefit, corresponds to 'totalHours' in the look-back period.
	CostWithoutBenefit *float64

	// READ-ONLY; An ISO 4217 currency code identifier for the costs and savings amounts.
	CurrencyCode *string

	// READ-ONLY; The first usage date used for looking back for computing the recommendations.
	FirstConsumptionDate *time.Time

	// READ-ONLY; The last usage date used for looking back for computing the recommendations.
	LastConsumptionDate *time.Time

	// READ-ONLY; The total hours for which the cost is covered. Its equal to number of records in a property 'properties/usage/charges'.
	TotalHours *int32
}

// GetBenefitRecommendationProperties implements the BenefitRecommendationPropertiesClassification interface for type SharedScopeBenefitRecommendationProperties.
func (s *SharedScopeBenefitRecommendationProperties) GetBenefitRecommendationProperties() *BenefitRecommendationProperties {
	return &BenefitRecommendationProperties{
		AllRecommendationDetails: s.AllRecommendationDetails,
		ArmSKUName:               s.ArmSKUName,
		CommitmentGranularity:    s.CommitmentGranularity,
		CostWithoutBenefit:       s.CostWithoutBenefit,
		CurrencyCode:             s.CurrencyCode,
		FirstConsumptionDate:     s.FirstConsumptionDate,
		LastConsumptionDate:      s.LastConsumptionDate,
		LookBackPeriod:           s.LookBackPeriod,
		RecommendationDetails:    s.RecommendationDetails,
		Scope:                    s.Scope,
		Term:                     s.Term,
		TotalHours:               s.TotalHours,
		Usage:                    s.Usage,
	}
}

// SingleScopeBenefitRecommendationProperties - The properties of the benefit recommendations when scope is 'Single'.
type SingleScopeBenefitRecommendationProperties struct {
	// REQUIRED; Benefit scope. For example, Single or Shared.
	Scope *Scope

	// Grain of the proposed commitment amount. Supported values: 'Hourly'
	CommitmentGranularity *Grain

	// The number of days of usage evaluated for computing the recommendations.
	LookBackPeriod *LookBackPeriod

	// The details of the proposed recommendation.
	RecommendationDetails *AllSavingsBenefitDetails

	// Term period of the benefit. For example, P1Y or P3Y.
	Term *Term

	// On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations.
	Usage *RecommendationUsageDetails

	// READ-ONLY; The list of all benefit recommendations with the recommendation details.
	AllRecommendationDetails *AllSavingsList

	// READ-ONLY; ARM SKU name. 'ComputeSavingsPlan' for SavingsPlan.
	ArmSKUName *string

	// READ-ONLY; The current cost without benefit, corresponds to 'totalHours' in the look-back period.
	CostWithoutBenefit *float64

	// READ-ONLY; An ISO 4217 currency code identifier for the costs and savings amounts.
	CurrencyCode *string

	// READ-ONLY; The first usage date used for looking back for computing the recommendations.
	FirstConsumptionDate *time.Time

	// READ-ONLY; The last usage date used for looking back for computing the recommendations.
	LastConsumptionDate *time.Time

	// READ-ONLY; The resource group that this single scope recommendation is for. Applicable only if recommendation is for 'Single'
	// scope and 'ResourceGroup' request scope.
	ResourceGroup *string

	// READ-ONLY; The subscription ID that this single scope recommendation is for. Applicable only if recommendation is for 'Single'
	// scope.
	SubscriptionID *string

	// READ-ONLY; The total hours for which the cost is covered. Its equal to number of records in a property 'properties/usage/charges'.
	TotalHours *int32
}

// GetBenefitRecommendationProperties implements the BenefitRecommendationPropertiesClassification interface for type SingleScopeBenefitRecommendationProperties.
func (s *SingleScopeBenefitRecommendationProperties) GetBenefitRecommendationProperties() *BenefitRecommendationProperties {
	return &BenefitRecommendationProperties{
		AllRecommendationDetails: s.AllRecommendationDetails,
		ArmSKUName:               s.ArmSKUName,
		CommitmentGranularity:    s.CommitmentGranularity,
		CostWithoutBenefit:       s.CostWithoutBenefit,
		CurrencyCode:             s.CurrencyCode,
		FirstConsumptionDate:     s.FirstConsumptionDate,
		LastConsumptionDate:      s.LastConsumptionDate,
		LookBackPeriod:           s.LookBackPeriod,
		RecommendationDetails:    s.RecommendationDetails,
		Scope:                    s.Scope,
		Term:                     s.Term,
		TotalHours:               s.TotalHours,
		Usage:                    s.Usage,
	}
}

// Status - The status of the long running operation.
type Status struct {
	// The status of the long running operation.
	Status *ReportOperationStatusType
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// View - States and configurations of Cost Analysis.
type View struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// The properties of the view.
	Properties *ViewProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ViewListResult - Result of listing views. It contains a list of available views.
type ViewListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of views.
	Value []*View
}

// ViewProperties - The properties of the view.
type ViewProperties struct {
	// Show costs accumulated over time.
	Accumulated *AccumulatedType

	// Chart type of the main view in Cost Analysis. Required.
	Chart *ChartType

	// User input name of the view. Required.
	DisplayName *string

	// List of KPIs to show in Cost Analysis UI.
	Kpis []*KpiProperties

	// Metric to use when displaying costs.
	Metric *MetricType

	// Configuration of 3 sub-views in the Cost Analysis UI.
	Pivots []*PivotProperties

	// Query body configuration. Required.
	Query *ReportConfigDefinition

	// Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
	// for resourceGroup
	// scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}'
	// for
	// Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
	// for EnrollmentAccount scope,
	// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
	// scope,
	// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
	// scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for
	// Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
	// ExternalBillingAccount scope, and
	// '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
	Scope *string

	// READ-ONLY; Date the user created this view.
	CreatedOn *time.Time

	// READ-ONLY; Currency of the current view.
	Currency *string

	// READ-ONLY; Date range of the current view.
	DateRange *string

	// READ-ONLY; Date when the user last modified this view.
	ModifiedOn *time.Time
}
