//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeducation

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// StudentLabsClient contains the methods for the StudentLabs group.
// Don't use this type directly, use NewStudentLabsClient() instead.
type StudentLabsClient struct {
	internal *arm.Client
}

// NewStudentLabsClient creates a new instance of StudentLabsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewStudentLabsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*StudentLabsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &StudentLabsClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get the details for a specified lab associated with the student lab.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01-preview
//   - studentLabName - Student lab name.
//   - options - StudentLabsClientGetOptions contains the optional parameters for the StudentLabsClient.Get method.
func (client *StudentLabsClient) Get(ctx context.Context, studentLabName string, options *StudentLabsClientGetOptions) (StudentLabsClientGetResponse, error) {
	var err error
	const operationName = "StudentLabsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, studentLabName, options)
	if err != nil {
		return StudentLabsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StudentLabsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StudentLabsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *StudentLabsClient) getCreateRequest(ctx context.Context, studentLabName string, options *StudentLabsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Education/studentLabs/{studentLabName}"
	if studentLabName == "" {
		return nil, errors.New("parameter studentLabName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{studentLabName}", url.PathEscape(studentLabName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *StudentLabsClient) getHandleResponse(resp *http.Response) (StudentLabsClientGetResponse, error) {
	result := StudentLabsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StudentLabDetails); err != nil {
		return StudentLabsClientGetResponse{}, err
	}
	return result, nil
}

// NewListAllPager - Get a list of all labs associated with the caller of the API.
//
// Generated from API version 2021-12-01-preview
//   - options - StudentLabsClientListAllOptions contains the optional parameters for the StudentLabsClient.NewListAllPager method.
func (client *StudentLabsClient) NewListAllPager(options *StudentLabsClientListAllOptions) *runtime.Pager[StudentLabsClientListAllResponse] {
	return runtime.NewPager(runtime.PagingHandler[StudentLabsClientListAllResponse]{
		More: func(page StudentLabsClientListAllResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StudentLabsClientListAllResponse) (StudentLabsClientListAllResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StudentLabsClient.NewListAllPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAllCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return StudentLabsClientListAllResponse{}, err
			}
			return client.listAllHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAllCreateRequest creates the ListAll request.
func (client *StudentLabsClient) listAllCreateRequest(ctx context.Context, options *StudentLabsClientListAllOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Education/studentLabs"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAllHandleResponse handles the ListAll response.
func (client *StudentLabsClient) listAllHandleResponse(resp *http.Response) (StudentLabsClientListAllResponse, error) {
	result := StudentLabsClientListAllResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StudentLabListResult); err != nil {
		return StudentLabsClientListAllResponse{}, err
	}
	return result, nil
}
