//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcompute

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAgentVersionClient creates a new instance of AgentVersionClient.
func (c *ClientFactory) NewAgentVersionClient() *AgentVersionClient {
	subClient, _ := NewAgentVersionClient(c.credential, c.options)
	return subClient
}

// NewExtensionMetadataClient creates a new instance of ExtensionMetadataClient.
func (c *ClientFactory) NewExtensionMetadataClient() *ExtensionMetadataClient {
	subClient, _ := NewExtensionMetadataClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewHybridIdentityMetadataClient creates a new instance of HybridIdentityMetadataClient.
func (c *ClientFactory) NewHybridIdentityMetadataClient() *HybridIdentityMetadataClient {
	subClient, _ := NewHybridIdentityMetadataClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLicenseProfilesClient creates a new instance of LicenseProfilesClient.
func (c *ClientFactory) NewLicenseProfilesClient() *LicenseProfilesClient {
	subClient, _ := NewLicenseProfilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLicensesClient creates a new instance of LicensesClient.
func (c *ClientFactory) NewLicensesClient() *LicensesClient {
	subClient, _ := NewLicensesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMachineExtensionsClient creates a new instance of MachineExtensionsClient.
func (c *ClientFactory) NewMachineExtensionsClient() *MachineExtensionsClient {
	subClient, _ := NewMachineExtensionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMachinesClient creates a new instance of MachinesClient.
func (c *ClientFactory) NewMachinesClient() *MachinesClient {
	subClient, _ := NewMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagementClient creates a new instance of ManagementClient.
func (c *ClientFactory) NewManagementClient() *ManagementClient {
	subClient, _ := NewManagementClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkProfileClient creates a new instance of NetworkProfileClient.
func (c *ClientFactory) NewNetworkProfileClient() *NetworkProfileClient {
	subClient, _ := NewNetworkProfileClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkScopesClient creates a new instance of PrivateLinkScopesClient.
func (c *ClientFactory) NewPrivateLinkScopesClient() *PrivateLinkScopesClient {
	subClient, _ := NewPrivateLinkScopesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
