//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AssetTrackOperationStatusesServer is a fake server for instances of the armmediaservices.AssetTrackOperationStatusesClient type.
type AssetTrackOperationStatusesServer struct {
	// Get is the fake for method AssetTrackOperationStatusesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, assetName string, trackName string, operationID string, options *armmediaservices.AssetTrackOperationStatusesClientGetOptions) (resp azfake.Responder[armmediaservices.AssetTrackOperationStatusesClientGetResponse], errResp azfake.ErrorResponder)
}

// NewAssetTrackOperationStatusesServerTransport creates a new instance of AssetTrackOperationStatusesServerTransport with the provided implementation.
// The returned AssetTrackOperationStatusesServerTransport instance is connected to an instance of armmediaservices.AssetTrackOperationStatusesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAssetTrackOperationStatusesServerTransport(srv *AssetTrackOperationStatusesServer) *AssetTrackOperationStatusesServerTransport {
	return &AssetTrackOperationStatusesServerTransport{srv: srv}
}

// AssetTrackOperationStatusesServerTransport connects instances of armmediaservices.AssetTrackOperationStatusesClient to instances of AssetTrackOperationStatusesServer.
// Don't use this type directly, use NewAssetTrackOperationStatusesServerTransport instead.
type AssetTrackOperationStatusesServerTransport struct {
	srv *AssetTrackOperationStatusesServer
}

// Do implements the policy.Transporter interface for AssetTrackOperationStatusesServerTransport.
func (a *AssetTrackOperationStatusesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AssetTrackOperationStatusesClient.Get":
		resp, err = a.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AssetTrackOperationStatusesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks/(?P<trackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationStatuses/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
	if err != nil {
		return nil, err
	}
	trackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trackName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, assetNameParam, trackNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AssetTrackOperationStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
