//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtemplatespecs

import "time"

// AzureResourceBase - Common properties for all Azure resources.
type AzureResourceBase struct {
	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// Error - Template Specs error response.
type Error struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.)
	Error *ErrorResponse
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorResponse

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// LinkedTemplateArtifact - Represents a Template Spec artifact containing an embedded Azure Resource Manager template for
// use as a linked template.
type LinkedTemplateArtifact struct {
	// REQUIRED; A filesystem safe relative path of the artifact.
	Path *string

	// REQUIRED; The Azure Resource Manager template.
	Template any
}

// ListResult - List of Template Specs.
type ListResult struct {
	// An array of Template Specs.
	Value []*TemplateSpec

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TemplateSpec - Template Spec object.
type TemplateSpec struct {
	// REQUIRED; The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported
	// Azure locations.
	Location *string

	// Template Spec properties.
	Properties *TemplateSpecProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// TemplateSpecProperties - Template Spec properties.
type TemplateSpecProperties struct {
	// Template Spec description.
	Description *string

	// Template Spec display name.
	DisplayName *string

	// The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
	Metadata any

	// READ-ONLY; High-level information about the versions within this Template Spec. The keys are the version names. Only populated
	// if the $expand query parameter is set to 'versions'.
	Versions map[string]*TemplateSpecVersionInfo
}

// TemplateSpecUpdateModel - Template Spec properties to be updated (only tags are currently supported).
type TemplateSpecUpdateModel struct {
	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// TemplateSpecVersion - Template Spec Version object.
type TemplateSpecVersion struct {
	// REQUIRED; The location of the Template Spec Version. It must match the location of the parent Template Spec.
	Location *string

	// REQUIRED; Template Spec Version properties.
	Properties *TemplateSpecVersionProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// TemplateSpecVersionInfo - High-level information about a Template Spec version.
type TemplateSpecVersionInfo struct {
	// READ-ONLY; Template Spec version description.
	Description *string

	// READ-ONLY; The timestamp of when the version was created.
	TimeCreated *time.Time

	// READ-ONLY; The timestamp of when the version was last modified.
	TimeModified *time.Time
}

// TemplateSpecVersionProperties - Template Spec Version properties.
type TemplateSpecVersionProperties struct {
	// Template Spec version description.
	Description *string

	// An array of linked template artifacts.
	LinkedTemplates []*LinkedTemplateArtifact

	// The main Azure Resource Manager template content.
	MainTemplate any

	// The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
	Metadata any

	// The Azure Resource Manager template UI definition content.
	UIFormDefinition any
}

// TemplateSpecVersionUpdateModel - Template Spec Version properties to be updated (only tags are currently supported).
type TemplateSpecVersionUpdateModel struct {
	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// TemplateSpecVersionsListResult - List of Template Specs versions
type TemplateSpecVersionsListResult struct {
	// An array of Template Spec versions.
	Value []*TemplateSpecVersion

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string
}
