//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagecache/armstoragecache/v3"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// CachesServer is a fake server for instances of the armstoragecache.CachesClient type.
type CachesServer struct {
	// BeginCreateOrUpdate is the fake for method CachesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, cacheName string, cache armstoragecache.Cache, options *armstoragecache.CachesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDebugInfo is the fake for method CachesClient.BeginDebugInfo
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDebugInfo func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginDebugInfoOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientDebugInfoResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CachesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginDeleteOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginFlush is the fake for method CachesClient.BeginFlush
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginFlush func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginFlushOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientFlushResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CachesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientGetOptions) (resp azfake.Responder[armstoragecache.CachesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CachesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armstoragecache.CachesClientListOptions) (resp azfake.PagerResponder[armstoragecache.CachesClientListResponse])

	// NewListByResourceGroupPager is the fake for method CachesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armstoragecache.CachesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armstoragecache.CachesClientListByResourceGroupResponse])

	// BeginPausePrimingJob is the fake for method CachesClient.BeginPausePrimingJob
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginPausePrimingJob func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginPausePrimingJobOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientPausePrimingJobResponse], errResp azfake.ErrorResponder)

	// BeginResumePrimingJob is the fake for method CachesClient.BeginResumePrimingJob
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginResumePrimingJob func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginResumePrimingJobOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientResumePrimingJobResponse], errResp azfake.ErrorResponder)

	// BeginSpaceAllocation is the fake for method CachesClient.BeginSpaceAllocation
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginSpaceAllocation func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginSpaceAllocationOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientSpaceAllocationResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method CachesClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginStart func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginStartOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStartPrimingJob is the fake for method CachesClient.BeginStartPrimingJob
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginStartPrimingJob func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginStartPrimingJobOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientStartPrimingJobResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method CachesClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginStop func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginStopOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientStopResponse], errResp azfake.ErrorResponder)

	// BeginStopPrimingJob is the fake for method CachesClient.BeginStopPrimingJob
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginStopPrimingJob func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginStopPrimingJobOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientStopPrimingJobResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method CachesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, cacheName string, cache armstoragecache.Cache, options *armstoragecache.CachesClientBeginUpdateOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpgradeFirmware is the fake for method CachesClient.BeginUpgradeFirmware
	// HTTP status codes to indicate success: http.StatusCreated, http.StatusAccepted, http.StatusNoContent
	BeginUpgradeFirmware func(ctx context.Context, resourceGroupName string, cacheName string, options *armstoragecache.CachesClientBeginUpgradeFirmwareOptions) (resp azfake.PollerResponder[armstoragecache.CachesClientUpgradeFirmwareResponse], errResp azfake.ErrorResponder)
}

// NewCachesServerTransport creates a new instance of CachesServerTransport with the provided implementation.
// The returned CachesServerTransport instance is connected to an instance of armstoragecache.CachesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCachesServerTransport(srv *CachesServer) *CachesServerTransport {
	return &CachesServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armstoragecache.CachesClientCreateOrUpdateResponse]](),
		beginDebugInfo:              newTracker[azfake.PollerResponder[armstoragecache.CachesClientDebugInfoResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armstoragecache.CachesClientDeleteResponse]](),
		beginFlush:                  newTracker[azfake.PollerResponder[armstoragecache.CachesClientFlushResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armstoragecache.CachesClientListResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armstoragecache.CachesClientListByResourceGroupResponse]](),
		beginPausePrimingJob:        newTracker[azfake.PollerResponder[armstoragecache.CachesClientPausePrimingJobResponse]](),
		beginResumePrimingJob:       newTracker[azfake.PollerResponder[armstoragecache.CachesClientResumePrimingJobResponse]](),
		beginSpaceAllocation:        newTracker[azfake.PollerResponder[armstoragecache.CachesClientSpaceAllocationResponse]](),
		beginStart:                  newTracker[azfake.PollerResponder[armstoragecache.CachesClientStartResponse]](),
		beginStartPrimingJob:        newTracker[azfake.PollerResponder[armstoragecache.CachesClientStartPrimingJobResponse]](),
		beginStop:                   newTracker[azfake.PollerResponder[armstoragecache.CachesClientStopResponse]](),
		beginStopPrimingJob:         newTracker[azfake.PollerResponder[armstoragecache.CachesClientStopPrimingJobResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armstoragecache.CachesClientUpdateResponse]](),
		beginUpgradeFirmware:        newTracker[azfake.PollerResponder[armstoragecache.CachesClientUpgradeFirmwareResponse]](),
	}
}

// CachesServerTransport connects instances of armstoragecache.CachesClient to instances of CachesServer.
// Don't use this type directly, use NewCachesServerTransport instead.
type CachesServerTransport struct {
	srv                         *CachesServer
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armstoragecache.CachesClientCreateOrUpdateResponse]]
	beginDebugInfo              *tracker[azfake.PollerResponder[armstoragecache.CachesClientDebugInfoResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armstoragecache.CachesClientDeleteResponse]]
	beginFlush                  *tracker[azfake.PollerResponder[armstoragecache.CachesClientFlushResponse]]
	newListPager                *tracker[azfake.PagerResponder[armstoragecache.CachesClientListResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armstoragecache.CachesClientListByResourceGroupResponse]]
	beginPausePrimingJob        *tracker[azfake.PollerResponder[armstoragecache.CachesClientPausePrimingJobResponse]]
	beginResumePrimingJob       *tracker[azfake.PollerResponder[armstoragecache.CachesClientResumePrimingJobResponse]]
	beginSpaceAllocation        *tracker[azfake.PollerResponder[armstoragecache.CachesClientSpaceAllocationResponse]]
	beginStart                  *tracker[azfake.PollerResponder[armstoragecache.CachesClientStartResponse]]
	beginStartPrimingJob        *tracker[azfake.PollerResponder[armstoragecache.CachesClientStartPrimingJobResponse]]
	beginStop                   *tracker[azfake.PollerResponder[armstoragecache.CachesClientStopResponse]]
	beginStopPrimingJob         *tracker[azfake.PollerResponder[armstoragecache.CachesClientStopPrimingJobResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armstoragecache.CachesClientUpdateResponse]]
	beginUpgradeFirmware        *tracker[azfake.PollerResponder[armstoragecache.CachesClientUpgradeFirmwareResponse]]
}

// Do implements the policy.Transporter interface for CachesServerTransport.
func (c *CachesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CachesClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "CachesClient.BeginDebugInfo":
		resp, err = c.dispatchBeginDebugInfo(req)
	case "CachesClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CachesClient.BeginFlush":
		resp, err = c.dispatchBeginFlush(req)
	case "CachesClient.Get":
		resp, err = c.dispatchGet(req)
	case "CachesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "CachesClient.NewListByResourceGroupPager":
		resp, err = c.dispatchNewListByResourceGroupPager(req)
	case "CachesClient.BeginPausePrimingJob":
		resp, err = c.dispatchBeginPausePrimingJob(req)
	case "CachesClient.BeginResumePrimingJob":
		resp, err = c.dispatchBeginResumePrimingJob(req)
	case "CachesClient.BeginSpaceAllocation":
		resp, err = c.dispatchBeginSpaceAllocation(req)
	case "CachesClient.BeginStart":
		resp, err = c.dispatchBeginStart(req)
	case "CachesClient.BeginStartPrimingJob":
		resp, err = c.dispatchBeginStartPrimingJob(req)
	case "CachesClient.BeginStop":
		resp, err = c.dispatchBeginStop(req)
	case "CachesClient.BeginStopPrimingJob":
		resp, err = c.dispatchBeginStopPrimingJob(req)
	case "CachesClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	case "CachesClient.BeginUpgradeFirmware":
		resp, err = c.dispatchBeginUpgradeFirmware(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragecache.Cache](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, cacheNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginDebugInfo(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDebugInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDebugInfo not implemented")}
	}
	beginDebugInfo := c.beginDebugInfo.get(req)
	if beginDebugInfo == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/debugInfo`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDebugInfo(req.Context(), resourceGroupNameParam, cacheNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDebugInfo = &respr
		c.beginDebugInfo.add(req, beginDebugInfo)
	}

	resp, err := server.PollerResponderNext(beginDebugInfo, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDebugInfo.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDebugInfo) {
		c.beginDebugInfo.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, cacheNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginFlush(req *http.Request) (*http.Response, error) {
	if c.srv.BeginFlush == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFlush not implemented")}
	}
	beginFlush := c.beginFlush.get(req)
	if beginFlush == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/flush`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginFlush(req.Context(), resourceGroupNameParam, cacheNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFlush = &respr
		c.beginFlush.add(req, beginFlush)
	}

	resp, err := server.PollerResponderNext(beginFlush, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginFlush.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFlush) {
		c.beginFlush.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, cacheNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Cache, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CachesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListPager(nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armstoragecache.CachesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *CachesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := c.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		c.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armstoragecache.CachesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		c.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginPausePrimingJob(req *http.Request) (*http.Response, error) {
	if c.srv.BeginPausePrimingJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPausePrimingJob not implemented")}
	}
	beginPausePrimingJob := c.beginPausePrimingJob.get(req)
	if beginPausePrimingJob == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pausePrimingJob`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragecache.PrimingJobIDParameter](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		var options *armstoragecache.CachesClientBeginPausePrimingJobOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstoragecache.CachesClientBeginPausePrimingJobOptions{
				PrimingJobID: &body,
			}
		}
		respr, errRespr := c.srv.BeginPausePrimingJob(req.Context(), resourceGroupNameParam, cacheNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPausePrimingJob = &respr
		c.beginPausePrimingJob.add(req, beginPausePrimingJob)
	}

	resp, err := server.PollerResponderNext(beginPausePrimingJob, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginPausePrimingJob.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPausePrimingJob) {
		c.beginPausePrimingJob.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginResumePrimingJob(req *http.Request) (*http.Response, error) {
	if c.srv.BeginResumePrimingJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResumePrimingJob not implemented")}
	}
	beginResumePrimingJob := c.beginResumePrimingJob.get(req)
	if beginResumePrimingJob == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resumePrimingJob`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragecache.PrimingJobIDParameter](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		var options *armstoragecache.CachesClientBeginResumePrimingJobOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstoragecache.CachesClientBeginResumePrimingJobOptions{
				PrimingJobID: &body,
			}
		}
		respr, errRespr := c.srv.BeginResumePrimingJob(req.Context(), resourceGroupNameParam, cacheNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResumePrimingJob = &respr
		c.beginResumePrimingJob.add(req, beginResumePrimingJob)
	}

	resp, err := server.PollerResponderNext(beginResumePrimingJob, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginResumePrimingJob.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResumePrimingJob) {
		c.beginResumePrimingJob.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginSpaceAllocation(req *http.Request) (*http.Response, error) {
	if c.srv.BeginSpaceAllocation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSpaceAllocation not implemented")}
	}
	beginSpaceAllocation := c.beginSpaceAllocation.get(req)
	if beginSpaceAllocation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/spaceAllocation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[[]*armstoragecache.StorageTargetSpaceAllocation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		var options *armstoragecache.CachesClientBeginSpaceAllocationOptions
		if len(body) > 0 {
			options = &armstoragecache.CachesClientBeginSpaceAllocationOptions{
				SpaceAllocation: body,
			}
		}
		respr, errRespr := c.srv.BeginSpaceAllocation(req.Context(), resourceGroupNameParam, cacheNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSpaceAllocation = &respr
		c.beginSpaceAllocation.add(req, beginSpaceAllocation)
	}

	resp, err := server.PollerResponderNext(beginSpaceAllocation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		c.beginSpaceAllocation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSpaceAllocation) {
		c.beginSpaceAllocation.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if c.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := c.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginStart(req.Context(), resourceGroupNameParam, cacheNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		c.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		c.beginStart.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginStartPrimingJob(req *http.Request) (*http.Response, error) {
	if c.srv.BeginStartPrimingJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartPrimingJob not implemented")}
	}
	beginStartPrimingJob := c.beginStartPrimingJob.get(req)
	if beginStartPrimingJob == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/startPrimingJob`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragecache.PrimingJob](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		var options *armstoragecache.CachesClientBeginStartPrimingJobOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstoragecache.CachesClientBeginStartPrimingJobOptions{
				Primingjob: &body,
			}
		}
		respr, errRespr := c.srv.BeginStartPrimingJob(req.Context(), resourceGroupNameParam, cacheNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartPrimingJob = &respr
		c.beginStartPrimingJob.add(req, beginStartPrimingJob)
	}

	resp, err := server.PollerResponderNext(beginStartPrimingJob, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		c.beginStartPrimingJob.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartPrimingJob) {
		c.beginStartPrimingJob.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if c.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := c.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginStop(req.Context(), resourceGroupNameParam, cacheNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		c.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		c.beginStop.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginStopPrimingJob(req *http.Request) (*http.Response, error) {
	if c.srv.BeginStopPrimingJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStopPrimingJob not implemented")}
	}
	beginStopPrimingJob := c.beginStopPrimingJob.get(req)
	if beginStopPrimingJob == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stopPrimingJob`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragecache.PrimingJobIDParameter](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		var options *armstoragecache.CachesClientBeginStopPrimingJobOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstoragecache.CachesClientBeginStopPrimingJobOptions{
				PrimingJobID: &body,
			}
		}
		respr, errRespr := c.srv.BeginStopPrimingJob(req.Context(), resourceGroupNameParam, cacheNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStopPrimingJob = &respr
		c.beginStopPrimingJob.add(req, beginStopPrimingJob)
	}

	resp, err := server.PollerResponderNext(beginStopPrimingJob, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginStopPrimingJob.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStopPrimingJob) {
		c.beginStopPrimingJob.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragecache.Cache](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), resourceGroupNameParam, cacheNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}

func (c *CachesServerTransport) dispatchBeginUpgradeFirmware(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpgradeFirmware == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpgradeFirmware not implemented")}
	}
	beginUpgradeFirmware := c.beginUpgradeFirmware.get(req)
	if beginUpgradeFirmware == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgrade`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpgradeFirmware(req.Context(), resourceGroupNameParam, cacheNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpgradeFirmware = &respr
		c.beginUpgradeFirmware.add(req, beginUpgradeFirmware)
	}

	resp, err := server.PollerResponderNext(beginUpgradeFirmware, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginUpgradeFirmware.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpgradeFirmware) {
		c.beginUpgradeFirmware.remove(req)
	}

	return resp, nil
}
