//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// TicketChatTranscriptsNoSubscriptionClient contains the methods for the SupportTicketChatTranscriptsNoSubscription group.
// Don't use this type directly, use NewTicketChatTranscriptsNoSubscriptionClient() instead.
type TicketChatTranscriptsNoSubscriptionClient struct {
	internal *arm.Client
}

// NewTicketChatTranscriptsNoSubscriptionClient creates a new instance of TicketChatTranscriptsNoSubscriptionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewTicketChatTranscriptsNoSubscriptionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*TicketChatTranscriptsNoSubscriptionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &TicketChatTranscriptsNoSubscriptionClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Lists all chat transcripts for a support ticket
//
// Generated from API version 2022-09-01-preview
//   - supportTicketName - Support ticket name
//   - options - TicketChatTranscriptsNoSubscriptionClientListOptions contains the optional parameters for the TicketChatTranscriptsNoSubscriptionClient.NewListPager
//     method.
func (client *TicketChatTranscriptsNoSubscriptionClient) NewListPager(supportTicketName string, options *TicketChatTranscriptsNoSubscriptionClientListOptions) *runtime.Pager[TicketChatTranscriptsNoSubscriptionClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[TicketChatTranscriptsNoSubscriptionClientListResponse]{
		More: func(page TicketChatTranscriptsNoSubscriptionClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *TicketChatTranscriptsNoSubscriptionClientListResponse) (TicketChatTranscriptsNoSubscriptionClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "TicketChatTranscriptsNoSubscriptionClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, supportTicketName, options)
			}, nil)
			if err != nil {
				return TicketChatTranscriptsNoSubscriptionClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *TicketChatTranscriptsNoSubscriptionClient) listCreateRequest(ctx context.Context, supportTicketName string, options *TicketChatTranscriptsNoSubscriptionClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts"
	if supportTicketName == "" {
		return nil, errors.New("parameter supportTicketName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{supportTicketName}", url.PathEscape(supportTicketName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *TicketChatTranscriptsNoSubscriptionClient) listHandleResponse(resp *http.Response) (TicketChatTranscriptsNoSubscriptionClientListResponse, error) {
	result := TicketChatTranscriptsNoSubscriptionClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChatTranscriptsListResult); err != nil {
		return TicketChatTranscriptsNoSubscriptionClientListResponse{}, err
	}
	return result, nil
}
