//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/Library_Get.json
func ExampleLibraryClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLibraryClient().Get(ctx, "exampleResourceGroup", "exampleLibraryName.jar", "exampleWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LibraryResource = armsynapse.LibraryResource{
	// 	Name: to.Ptr("exampleLibraryName.jar"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/libraries"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Synapse/workspaces/exampleWorkspace/libraries/exampleLibraryName.jar"),
	// 	Etag: to.Ptr("1500474f-0000-0200-0000-5cbe090d0000"),
	// 	Properties: &armsynapse.LibraryInfo{
	// 		Name: to.Ptr("exampleLibraryName.jar"),
	// 		Type: to.Ptr("jar"),
	// 		Path: to.Ptr("exampleWorkspace/libraries/exampleLibraryName.jar"),
	// 		ContainerName: to.Ptr("exampleContainer"),
	// 		CreatorID: to.Ptr("2222222e-222d-222f-2222-22a2f222d2f2"),
	// 		ProvisioningStatus: to.Ptr("Succeeded"),
	// 		UploadedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-23T07:59:29.157Z"); return t}()),
	// 	},
	// }
}
