/*
Copyright (c) 1994 Cygnus Support.
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
and/or other materials related to such
distribution and use acknowledge that the software was developed
at Cygnus Support, Inc.  Cygnus Support, Inc. may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
/*
 * gmtime.c
 * Original Author:	G. Haley
 *
 * Converts the calendar time pointed to by tim_p into a broken-down time
 * expressed as Greenwich Mean Time (GMT). Returns a pointer to a structure
 * containing the broken-down time, or a null pointer if GMT is not
 * available.
 */

/*
FUNCTION
<<gmtime>>---convert time to UTC traditional form

INDEX
	gmtime
INDEX
	gmtime_r

SYNOPSIS
	#include <time.h>
	struct tm *gmtime(const time_t *<[clock]>);
	struct tm *gmtime_r(const time_t *<[clock]>, struct tm *<[res]>);

DESCRIPTION
<<gmtime>> takes the time at <[clock]> representing the number
of elapsed seconds since 00:00:00 on January 1, 1970, Universal
Coordinated Time (UTC, also known in some countries as GMT,
Greenwich Mean time) and converts it to a <<struct tm>>
representation.

<<gmtime>> constructs the traditional time representation in static
storage; each call to <<gmtime>> or <<localtime>> will overwrite the
information generated by previous calls to either function.

RETURNS
A pointer to the traditional time representation (<<struct tm>>).

PORTABILITY
ANSI C requires <<gmtime>>.

<<gmtime>> requires no supporting OS subroutines.
*/

#include <stdlib.h>
#include <time.h>

__THREAD_LOCAL struct tm _localtime_buf;
