# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.keyvault.aio import KeyVaultManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKeyVaultManagementMHSMPrivateEndpointConnectionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KeyVaultManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mhsm_private_endpoint_connections_get(self, resource_group):
        response = await self.client.mhsm_private_endpoint_connections.get(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mhsm_private_endpoint_connections_put(self, resource_group):
        response = await self.client.mhsm_private_endpoint_connections.put(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            properties={
                "etag": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "name": "str",
                "properties": {
                    "privateEndpoint": {"id": "str"},
                    "privateLinkServiceConnectionState": {
                        "actionsRequired": "str",
                        "description": "str",
                        "status": "str",
                    },
                    "provisioningState": "str",
                },
                "sku": {"family": "str", "name": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mhsm_private_endpoint_connections_begin_delete(self, resource_group):
        response = await (
            await self.client.mhsm_private_endpoint_connections.begin_delete(
                resource_group_name=resource_group.name,
                name="str",
                private_endpoint_connection_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mhsm_private_endpoint_connections_list_by_resource(self, resource_group):
        response = self.client.mhsm_private_endpoint_connections.list_by_resource(
            resource_group_name=resource_group.name,
            name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
