% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-metrics.R
\name{strings_sizes}
\alias{strings_sizes}
\title{Compute strings sizes}
\usage{
strings_sizes(
  x,
  fontname = "sans",
  fontsize = 10,
  bold = FALSE,
  italic = FALSE
)
}
\arguments{
\item{x}{A character vector of strings to measure. All arguments are vectorized
and recycled to match the length of \code{x}.}

\item{fontname}{A character vector specifying the font family name (e.g., "sans", "serif", "mono").
Default is "sans". This argument is vectorized.}

\item{fontsize}{A numeric vector specifying the font size in points.
Default is 10. This argument is vectorized.}

\item{bold}{A logical vector indicating whether the text should be bold.
Default is FALSE. This argument is vectorized.}

\item{italic}{A logical vector indicating whether the text should be italic.
Default is FALSE. This argument is vectorized.}
}
\description{
This function is a simple wrapper around \code{\link[systemfonts:string_metrics_dev]{systemfonts::string_metrics_dev()}}.
It determines widths, ascent and descent in inches.

This function will replace the following functions defined in this file:
\code{\link[=str_extents]{str_extents()}}, \code{\link[=str_metrics]{str_metrics()}} and \code{\link[=m_str_extents]{m_str_extents()}}.
}
\examples{
strings_sizes(letters)
strings_sizes("Hello World!", bold = TRUE, italic = FALSE,
  fontname = "sans", fontsize = 12)
}
