% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{download_font}
\alias{download_font}
\title{Download font files}
\usage{
download_font(id, output_dir, variants = NULL, ..., http_options = list())
}
\arguments{
\item{id}{Id of the font, correspond to column \code{id} from \code{\link{get_all_fonts}}.}

\item{output_dir}{Output directory where to save font files.}

\item{variants}{Variant(s) to download, default is to includes all available ones.}

\item{...}{Additional parameters to API query.}

\item{http_options}{Arguments passed to \code{crul::HttpClient$new}.}
}
\value{
a character vector of the filepaths extracted to, invisibly.
}
\description{
Download font files
}
\examples{
if (interactive()) {

# For example, we use a temporary directory
path_to_dir <- tempfile()
dir.create(path_to_dir)

# Download Roboto font
download_font(
  id = "roboto",
  output_dir = path_to_dir
)

# Get only regular, italic and bold
download_font(
  id = "roboto",
  output_dir = path_to_dir,
  variants = c("regular", "300italic", "700")
)

# Clean up
unlink(path_to_dir, recursive = TRUE)

}
}
