% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise-plot.R
\name{summarise_plot}
\alias{summarise_plot}
\alias{summarise_layout}
\alias{summarise_coord}
\alias{summarise_layers}
\title{Summarise built plot objects}
\usage{
summarise_layout(p)

summarise_coord(p)

summarise_layers(p)
}
\arguments{
\item{p}{A ggplot_built object.}
}
\description{
These functions provide summarised information about built ggplot objects.
}
\details{
There are three types of summary that can be obtained: A summary of the plot layout,
a summary of the plot coord, and a summary of plot layers.
}
\section{Layout summary}{


The function \code{summarise_layout()} returns a table that provides information about
the plot panel(s) in the built plot. The table has the following columns:

\describe{
\item{\code{panel}}{A factor indicating the individual plot panels.}
\item{\code{row}}{Row number in the grid of panels.}
\item{\code{col}}{Column number in the grid of panels.}
\item{\code{vars}}{A list of lists. For each panel, the respective list
provides the variables and their values that specify the panel.}
\item{\code{xmin}, \code{xmax}}{The minimum and maximum values of the variable mapped to
the x aesthetic, in transformed coordinates.}
\item{\code{ymin}, \code{ymax}}{The minimum and maximum values of the variable mapped to
the y aesthetic, in transformed coordinates.}
\item{\code{xscale}}{The scale object applied to the x aesthetic.}
\item{\code{yscale}}{The scale object applied to the y aesthetic.}
}

Importantly, the values for \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}, \code{xscale}, and \code{yscale}
are determined by the variables that are mapped to \code{x} and \code{y} in the \code{aes()} call.
So even if a coord changes how x and y are shown in the final plot (as is the case
for \code{coord_flip()} or \code{coord_polar()}), these changes have no effect on the results
returned by \code{summarise_plot()}.
}

\section{Coord summary}{


The function \code{summarise_coord()} returns information about the log base for
coordinates that are log-transformed in \code{coord_transform()}, and it also indicates
whether the coord has flipped the x and y axes.
}

\section{Layer summary}{


The function \code{summarise_layers()} returns a table with a single column, \code{mapping}, which
contains information about aesthetic mapping for each layer.
}

\examples{
p <-
  ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(~class)
b <- ggplot_build(p)

summarise_layout(b)
summarise_coord(b)
summarise_layers(b)

}
\keyword{internal}
