% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp.R
\name{mp}
\alias{mp}
\alias{make_indeterminate_list}
\title{Define a multivariate polynomial.}
\usage{
make_indeterminate_list(vars)

mp(string, varorder, stars_only = FALSE)
}
\arguments{
\item{vars}{a character vector of indeterminates}

\item{string}{a character string containing a polynomial, see examples}

\item{varorder}{(optional) order of variables in string}

\item{stars_only}{if you format your multiplications using asterisks, setting
this to \code{TRUE} will reduce preprocessing time}
}
\value{
An object of class mpoly.
}
\description{
mp is a smart function which attempts to create a formal mpoly object from a
character string containing the usual representation  of a multivariate
polynomial.
}
\examples{

( m <- mp("x + y + x y") )
is.mpoly( m )
unclass(m)

mp("1 + x")


mp("x + 2 y + x^2 y + x y z")
mp("x + 2 y + x^2 y + x y z", varorder = c("y", "z", "x"))

( ms <- mp(c("x + y", "2 x")) )
is.mpolyList(ms)


gradient( mp("x + 2 y + x^2 y + x y z") )
gradient( mp("(x + y)^10") )

# mp and the print methods are kinds of inverses of each other
( polys <- mp(c("x + y", "x - y")) )
strings <- print(polys, silent = TRUE)
strings
mp(strings)

}
\seealso{
\code{\link[=mpoly]{mpoly()}}
}
\author{
David Kahle \email{david@kahle.io}
}
